/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.world;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.config.ClientConfig;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.data.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.WorldParticleOptions;

public class GenericParticle
extends TextureSheetParticle {
    private final ParticleRenderType renderType;
    protected final ParticleEngine.MutableSpriteSet spriteSet;
    protected final SimpleParticleOptions.ParticleSpritePicker spritePicker;
    protected final SimpleParticleOptions.ParticleDiscardFunctionType discardFunctionType;
    protected final ColorParticleData colorData;
    protected final GenericParticleData transparencyData;
    protected final GenericParticleData scaleData;
    protected final SpinParticleData spinData;
    protected final Consumer<GenericParticle> actor;
    private boolean reachedPositiveAlpha;
    private boolean reachedPositiveScale;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public GenericParticle(ClientLevel world, WorldParticleOptions options, ParticleEngine.MutableSpriteSet spriteSet, double x, double y, double z, double xd, double yd, double zd) {
        super(world, x, y, z);
        this.renderType = options.renderType == null ? LodestoneWorldParticleRenderType.ADDITIVE : options.renderType;
        this.spriteSet = spriteSet;
        this.spritePicker = options.spritePicker;
        this.discardFunctionType = options.discardFunctionType;
        this.colorData = options.colorData;
        this.transparencyData = options.transparencyData;
        this.scaleData = options.scaleData;
        this.spinData = options.spinData;
        this.actor = options.actor;
        this.f_107231_ = options.spinData.spinOffset + options.spinData.startingValue;
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.m_107257_(options.lifetime);
        this.f_107226_ = options.gravity;
        this.f_107219_ = !options.noClip;
        this.f_172258_ = 1.0f;
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r1)), (int)(255.0f * Math.min(1.0f, this.colorData.g1)), (int)(255.0f * Math.min(1.0f, this.colorData.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r2)), (int)(255.0f * Math.min(1.0f, this.colorData.g2)), (int)(255.0f * Math.min(1.0f, this.colorData.b2)), this.hsv2);
        if (spriteSet != null) {
            if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.RANDOM_SPRITE)) {
                this.m_108335_((SpriteSet)spriteSet);
            }
            if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.FIRST_INDEX) || this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.WITH_AGE)) {
                this.pickSprite(0);
            }
            if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.LAST_INDEX)) {
                this.pickSprite(spriteSet.f_107406_.size() - 1);
            }
        }
        this.updateTraits();
    }

    protected int m_6355_(float pPartialTick) {
        return 0xF000F0;
    }

    public void m_5989_() {
        this.updateTraits();
        if (this.spriteSet != null && this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.WITH_AGE)) {
            this.m_108339_((SpriteSet)this.spriteSet);
        }
        super.m_5989_();
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTicks) {
        LodestoneWorldParticleRenderType renderType;
        ParticleRenderType particleRenderType;
        VertexConsumer consumerToUse = consumer;
        if (ClientConfig.DELAYED_PARTICLE_RENDERING.getConfigValue().booleanValue() && (particleRenderType = this.renderType) instanceof LodestoneWorldParticleRenderType && (renderType = (LodestoneWorldParticleRenderType)particleRenderType).shouldBuffer()) {
            consumerToUse = RenderHandler.DELAYED_PARTICLE_RENDER.m_6299_(renderType.getRenderType());
        }
        super.m_5744_(consumerToUse, camera, partialTicks);
    }

    public ParticleRenderType m_7556_() {
        return this.renderType;
    }

    public SimpleParticleOptions.ParticleSpritePicker getSpritePicker() {
        return this.spritePicker;
    }

    public void pickSprite(int spriteIndex) {
        if (spriteIndex < this.spriteSet.f_107406_.size() && spriteIndex >= 0) {
            this.m_108337_((TextureAtlasSprite)this.spriteSet.f_107406_.get(spriteIndex));
        }
    }

    public void pickColor(float colorCoeff) {
        float h = Mth.m_14189_((float)colorCoeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.m_14179_((float)colorCoeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.m_14179_((float)colorCoeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.m_13665_((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)packed) / 255.0f;
        this.m_107253_(r, g, b);
    }

    protected void updateTraits() {
        boolean shouldAttemptRemoval;
        boolean bl = shouldAttemptRemoval = this.discardFunctionType == SimpleParticleOptions.ParticleDiscardFunctionType.INVISIBLE;
        if (this.discardFunctionType == SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE && (this.scaleData.getProgress(this.f_107224_, this.f_107225_) > 0.5f || this.transparencyData.getProgress(this.f_107224_, this.f_107225_) > 0.5f)) {
            shouldAttemptRemoval = true;
        }
        if (shouldAttemptRemoval && (this.reachedPositiveAlpha && this.f_107230_ <= 0.0f || this.reachedPositiveScale && this.f_107663_ <= 0.0f)) {
            this.m_107274_();
            return;
        }
        if (!this.reachedPositiveAlpha && this.f_107230_ > 0.0f) {
            this.reachedPositiveAlpha = true;
        }
        if (!this.reachedPositiveScale && this.f_107663_ > 0.0f) {
            this.reachedPositiveScale = true;
        }
        this.pickColor(this.colorData.colorCurveEasing.ease(this.colorData.getProgress(this.f_107224_, this.f_107225_), 0.0f, 1.0f, 1.0f));
        this.f_107663_ = this.scaleData.getValue(this.f_107224_, this.f_107225_);
        this.f_107230_ = this.transparencyData.getValue(this.f_107224_, this.f_107225_);
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.spinData.getValue(this.f_107224_, this.f_107225_);
        if (this.actor != null) {
            this.actor.accept(this);
        }
    }

    public Vec3 getPos() {
        return new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public Vec3 getParticleSpeed() {
        return new Vec3(this.f_107215_, this.f_107216_, this.f_107217_);
    }

    public void setParticleSpeed(Vec3 speed) {
        this.m_172260_(speed.f_82479_, speed.f_82480_, speed.f_82481_);
    }
}

