/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.render.RenderHelper;
import team.lodestar.lodestone.systems.rendering.TrailPoint;

public class VFXBuilders {
    public static ScreenVFXBuilder createScreen() {
        return new ScreenVFXBuilder();
    }

    public static WorldVFXBuilder createWorld() {
        return new WorldVFXBuilder();
    }

    public static class ScreenVFXBuilder {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        int light = -1;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float x1 = 1.0f;
        float y1 = 1.0f;
        int zLevel;
        VertexFormat format;
        Supplier<ShaderInstance> shader = GameRenderer::m_172817_;
        ResourceLocation texture;
        ScreenVertexPlacementSupplier supplier;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();

        public ScreenVFXBuilder setPosTexDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.m_85982_(l, x, y, (float)this.zLevel).m_7421_(u, v).m_5752_();
            this.format = DefaultVertexFormat.f_85817_;
            return this;
        }

        public ScreenVFXBuilder setPosColorDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.m_85982_(l, x, y, (float)this.zLevel).m_85950_(this.r, this.g, this.b, this.a).m_5752_();
            this.format = DefaultVertexFormat.f_85815_;
            return this;
        }

        public ScreenVFXBuilder setPosColorTexDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.m_85982_(l, x, y, (float)this.zLevel).m_85950_(this.r, this.g, this.b, this.a).m_7421_(u, v).m_5752_();
            this.format = DefaultVertexFormat.f_85818_;
            return this;
        }

        public ScreenVFXBuilder setPosColorTexLightmapDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.m_85982_(l, x, y, (float)this.zLevel).m_85950_(this.r, this.g, this.b, this.a).m_7421_(u, v).m_85969_(this.light).m_5752_();
            this.format = DefaultVertexFormat.f_85820_;
            return this;
        }

        public ScreenVFXBuilder setFormat(VertexFormat format) {
            this.format = format;
            return this;
        }

        public ScreenVFXBuilder setShaderTexture(ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public ScreenVFXBuilder setShader(Supplier<ShaderInstance> shader) {
            this.shader = shader;
            return this;
        }

        public ScreenVFXBuilder setShader(ShaderInstance shader) {
            this.shader = () -> shader;
            return this;
        }

        public ScreenVFXBuilder setVertexSupplier(ScreenVertexPlacementSupplier supplier) {
            this.supplier = supplier;
            return this;
        }

        public ScreenVFXBuilder overrideBufferBuilder(BufferBuilder builder) {
            this.bufferbuilder = builder;
            return this;
        }

        public ScreenVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public ScreenVFXBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public ScreenVFXBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public ScreenVFXBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public ScreenVFXBuilder setColor(float r, float g, float b) {
            this.r = r / 255.0f;
            this.g = g / 255.0f;
            this.b = b / 255.0f;
            return this;
        }

        public ScreenVFXBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public ScreenVFXBuilder setPositionWithWidth(float x, float y, float width, float height) {
            return this.setPosition(x, y, x + width, y + height);
        }

        public ScreenVFXBuilder setPosition(float x0, float y0, float x1, float y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            return this;
        }

        public ScreenVFXBuilder setZLevel(int z) {
            this.zLevel = z;
            return this;
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSize) {
            return this.setUVWithWidth(u, v, width, height, canvasSize, canvasSize);
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSizeX, float canvasSizeY) {
            return this.setUVWithWidth(u / canvasSizeX, v / canvasSizeY, width / canvasSizeX, height / canvasSizeY);
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height) {
            this.u0 = u;
            this.v0 = v;
            this.u1 = u + width;
            this.v1 = v + height;
            return this;
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSize) {
            return this.setUV(u0, v0, u1, v1, canvasSize, canvasSize);
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSizeX, float canvasSizeY) {
            return this.setUV(u0 / canvasSizeX, v0 / canvasSizeY, u1 / canvasSizeX, v1 / canvasSizeY);
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public ScreenVFXBuilder blit(PoseStack stack) {
            Matrix4f last = stack.m_85850_().m_85861_();
            RenderSystem.m_157427_(this.shader);
            if (this.texture != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
            }
            this.supplier.placeVertex(this.bufferbuilder, last, this.x0, this.y1, this.u0, this.v1);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x1, this.y1, this.u1, this.v1);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x1, this.y0, this.u1, this.v0);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x0, this.y0, this.u0, this.v0);
            return this;
        }

        public ScreenVFXBuilder draw(PoseStack stack) {
            if (this.bufferbuilder.m_85732_()) {
                this.end();
            }
            this.begin();
            this.blit(stack);
            this.end();
            return this;
        }

        public ScreenVFXBuilder endAndProceed() {
            return this.end().begin();
        }

        public ScreenVFXBuilder begin() {
            this.bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, this.format);
            return this;
        }

        public ScreenVFXBuilder end() {
            BufferBuilder.RenderedBuffer renderedBuffer = this.bufferbuilder.m_231175_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderedBuffer);
            return this;
        }

        private static interface ScreenVertexPlacementSupplier {
            public void placeVertex(BufferBuilder var1, Matrix4f var2, float var3, float var4, float var5, float var6);
        }
    }

    public static class WorldVFXBuilder {
        protected float r = 1.0f;
        protected float g = 1.0f;
        protected float b = 1.0f;
        protected float a = 1.0f;
        protected int light = 0xF000F0;
        protected float u0 = 0.0f;
        protected float v0 = 0.0f;
        protected float u1 = 1.0f;
        protected float v1 = 1.0f;
        protected VertexFormat format;
        protected WorldVertexPlacementSupplier supplier;

        public WorldVFXBuilder setPosColorDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.m_5483_((double)x, (double)y, (double)z).m_85950_(this.r, this.g, this.b, this.a).m_5752_();
                } else {
                    c.m_85982_(l, x, y, z).m_85950_(this.r, this.g, this.b, this.a).m_5752_();
                }
            }).setFormat(DefaultVertexFormat.f_85815_);
        }

        public WorldVFXBuilder setPosColorLightmapDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.m_5483_((double)x, (double)y, (double)z).m_85950_(this.r, this.g, this.b, this.a).m_85969_(this.light).m_5752_();
                } else {
                    c.m_85982_(l, x, y, z).m_85950_(this.r, this.g, this.b, this.a).m_85969_(this.light).m_5752_();
                }
            }).setFormat(DefaultVertexFormat.f_85816_);
        }

        public WorldVFXBuilder setPosTexDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.m_5483_((double)x, (double)y, (double)z).m_7421_(u, v).m_5752_();
                } else {
                    c.m_85982_(l, x, y, z).m_7421_(u, v).m_5752_();
                }
            }).setFormat(DefaultVertexFormat.f_85817_);
        }

        public WorldVFXBuilder setPosColorTexDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.m_5483_((double)x, (double)y, (double)z).m_85950_(this.r, this.g, this.b, this.a).m_7421_(u, v).m_5752_();
                } else {
                    c.m_85982_(l, x, y, z).m_85950_(this.r, this.g, this.b, this.a).m_7421_(u, v).m_5752_();
                }
            }).setFormat(DefaultVertexFormat.f_85818_);
        }

        public WorldVFXBuilder setPosColorTexLightmapDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.m_5483_((double)x, (double)y, (double)z).m_85950_(this.r, this.g, this.b, this.a).m_7421_(u, v).m_85969_(this.light).m_5752_();
                } else {
                    c.m_85982_(l, x, y, z).m_85950_(this.r, this.g, this.b, this.a).m_7421_(u, v).m_85969_(this.light).m_5752_();
                }
            }).setFormat(DefaultVertexFormat.f_85820_);
        }

        public WorldVFXBuilder setFormat(VertexFormat format) {
            this.format = format;
            return this;
        }

        public WorldVFXBuilder setVertexSupplier(WorldVertexPlacementSupplier supplier) {
            this.supplier = supplier;
            return this;
        }

        public WorldVFXBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public WorldVFXBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public WorldVFXBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public WorldVFXBuilder setColor(float r, float g, float b) {
            this.r = r / 255.0f;
            this.g = g / 255.0f;
            this.b = b / 255.0f;
            return this;
        }

        public WorldVFXBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public WorldVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public WorldVFXBuilder setUV(TextureAtlasSprite sprite) {
            return this.setUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_());
        }

        public WorldVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public WorldVFXBuilder renderTrail(VertexConsumer vertexConsumer, PoseStack stack, Vector3f offset, List<Vector4f> trailSegments, Function<Float, Float> widthFunc) {
            return this.renderTrail(vertexConsumer, stack, offset, trailSegments, widthFunc, (Float f) -> {});
        }

        public WorldVFXBuilder renderTrail(VertexConsumer vertexConsumer, PoseStack stack, Vector3f offset, List<Vector4f> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
            return this.renderTrail(vertexConsumer, stack.m_85850_().m_85861_(), offset, trailSegments, widthFunc, vfxOperator);
        }

        public WorldVFXBuilder renderTrail(VertexConsumer vertexConsumer, Matrix4f pose, Vector3f offset, List<Vector4f> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
            if (trailSegments.size() < 3) {
                return this;
            }
            trailSegments = trailSegments.stream().map(v -> new Vector4f(v.m_123601_(), v.m_123615_(), v.m_123616_(), v.m_123617_())).collect(Collectors.toList());
            for (Vector4f vector4f : trailSegments) {
                vector4f.m_176875_(offset.m_122239_(), offset.m_122260_(), offset.m_122269_(), 0.0f);
                vector4f.m_123607_(pose);
            }
            int count = trailSegments.size() - 1;
            float f = 1.0f / (float)(count - 1);
            ArrayList<TrailPoint> points = new ArrayList<TrailPoint>();
            for (int i = 0; i < count; ++i) {
                float width = widthFunc.apply(Float.valueOf(f * (float)i)).floatValue();
                Vector4f start = (Vector4f)trailSegments.get(i);
                Vector4f end = (Vector4f)trailSegments.get(i + 1);
                points.add(new TrailPoint(RenderHelper.midpoint(start, end), RenderHelper.screenSpaceQuadOffsets(start, end, width)));
            }
            return this.renderPoints(vertexConsumer, points, this.u0, this.v0, this.u1, this.v1, vfxOperator);
        }

        public WorldVFXBuilder renderPoints(VertexConsumer vertexConsumer, List<TrailPoint> trailPoints, float u0, float v0, float u1, float v1, Consumer<Float> vfxOperator) {
            int count = trailPoints.size() - 1;
            float increment = 1.0f / (float)count;
            vfxOperator.accept(Float.valueOf(0.0f));
            trailPoints.get(0).renderStart(vertexConsumer, this.supplier, u0, v0, u1, Mth.m_14179_((float)increment, (float)v0, (float)v1));
            for (int i = 1; i < count; ++i) {
                float current = Mth.m_14179_((float)((float)i * increment), (float)v0, (float)v1);
                vfxOperator.accept(Float.valueOf(current));
                trailPoints.get(i).renderMid(vertexConsumer, this.supplier, u0, current, u1, current);
            }
            vfxOperator.accept(Float.valueOf(1.0f));
            trailPoints.get(count).renderEnd(vertexConsumer, this.supplier, u0, Mth.m_14179_((float)((float)count * increment), (float)v0, (float)v1), u1, v1);
            return this;
        }

        public WorldVFXBuilder renderBeam(VertexConsumer vertexConsumer, PoseStack stack, Vec3 start, Vec3 end, float width) {
            Minecraft minecraft = Minecraft.m_91087_();
            Matrix4f last = stack.m_85850_().m_85861_();
            Vec3 cameraPosition = minecraft.m_167982_().f_112249_.m_90583_();
            Vec3 delta = end.m_82546_(start);
            Vec3 normal = start.m_82546_(cameraPosition).m_82537_(delta).m_82541_().m_82542_((double)(width / 2.0f), (double)(width / 2.0f), (double)(width / 2.0f));
            Vec3[] positions = new Vec3[]{start.m_82546_(normal), start.m_82549_(normal), end.m_82549_(normal), end.m_82546_(normal)};
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[0].f_82479_, (float)positions[0].f_82480_, (float)positions[0].f_82481_, this.u0, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[1].f_82479_, (float)positions[1].f_82480_, (float)positions[1].f_82481_, this.u1, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[2].f_82479_, (float)positions[2].f_82480_, (float)positions[2].f_82481_, this.u1, this.v0);
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[3].f_82479_, (float)positions[3].f_82480_, (float)positions[3].f_82481_, this.u0, this.v0);
            return this;
        }

        public WorldVFXBuilder renderQuad(VertexConsumer vertexConsumer, PoseStack stack, float size) {
            return this.renderQuad(vertexConsumer, stack, size, size);
        }

        public WorldVFXBuilder renderQuad(VertexConsumer vertexConsumer, PoseStack stack, float width, float height) {
            Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f)};
            return this.renderQuad(vertexConsumer, stack, positions, width, height);
        }

        public WorldVFXBuilder renderQuad(VertexConsumer vertexConsumer, PoseStack stack, Vector3f[] positions, float size) {
            return this.renderQuad(vertexConsumer, stack, positions, size, size);
        }

        public WorldVFXBuilder renderQuad(VertexConsumer vertexConsumer, PoseStack stack, Vector3f[] positions, float width, float height) {
            for (Vector3f position : positions) {
                position.m_122263_(width, height, width);
            }
            return this.renderQuad(vertexConsumer, stack, positions);
        }

        public WorldVFXBuilder renderQuad(VertexConsumer vertexConsumer, PoseStack stack, Vector3f[] positions) {
            Matrix4f last = stack.m_85850_().m_85861_();
            this.supplier.placeVertex(vertexConsumer, last, positions[0].m_122239_(), positions[0].m_122260_(), positions[0].m_122269_(), this.u0, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, positions[1].m_122239_(), positions[1].m_122260_(), positions[1].m_122269_(), this.u1, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, positions[2].m_122239_(), positions[2].m_122260_(), positions[2].m_122269_(), this.u1, this.v0);
            this.supplier.placeVertex(vertexConsumer, last, positions[3].m_122239_(), positions[3].m_122260_(), positions[3].m_122269_(), this.u0, this.v0);
            return this;
        }

        public WorldVFXBuilder renderSphere(VertexConsumer vertexConsumer, PoseStack stack, float radius, int longs, int lats) {
            Matrix4f last = stack.m_85850_().m_85861_();
            float startU = 0.0f;
            float startV = 0.0f;
            float endU = (float)Math.PI * 2;
            float endV = (float)Math.PI;
            float stepU = (endU - startU) / (float)longs;
            float stepV = (endV - startV) / (float)lats;
            for (int i = 0; i < longs; ++i) {
                for (int j = 0; j < lats; ++j) {
                    float u = (float)i * stepU + startU;
                    float v = (float)j * stepV + startV;
                    float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                    float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                    Vector3f p0 = RenderHelper.parametricSphere(u, v, radius);
                    Vector3f p1 = RenderHelper.parametricSphere(u, vn, radius);
                    Vector3f p2 = RenderHelper.parametricSphere(un, v, radius);
                    Vector3f p3 = RenderHelper.parametricSphere(un, vn, radius);
                    float textureU = u / endU * radius;
                    float textureV = v / endV * radius;
                    float textureUN = un / endU * radius;
                    float textureVN = vn / endV * radius;
                    this.supplier.placeVertex(vertexConsumer, last, p0.m_122239_(), p0.m_122260_(), p0.m_122269_(), textureU, textureV);
                    this.supplier.placeVertex(vertexConsumer, last, p2.m_122239_(), p2.m_122260_(), p2.m_122269_(), textureUN, textureV);
                    this.supplier.placeVertex(vertexConsumer, last, p1.m_122239_(), p1.m_122260_(), p1.m_122269_(), textureU, textureVN);
                    this.supplier.placeVertex(vertexConsumer, last, p3.m_122239_(), p3.m_122260_(), p3.m_122269_(), textureUN, textureVN);
                    this.supplier.placeVertex(vertexConsumer, last, p1.m_122239_(), p1.m_122260_(), p1.m_122269_(), textureU, textureVN);
                    this.supplier.placeVertex(vertexConsumer, last, p2.m_122239_(), p2.m_122260_(), p2.m_122269_(), textureUN, textureV);
                }
            }
            return this;
        }

        public static interface WorldVertexPlacementSupplier {
            public void placeVertex(VertexConsumer var1, Matrix4f var2, float var3, float var4, float var5, float var6, float var7);
        }
    }
}

