/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.ghost;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.systems.rendering.ghost.GhostBlockOptions;

public abstract class GhostBlockRenderer {
    public static final GhostBlockRenderer STANDARD = new DefaultGhostBlockRenderer();

    public abstract void render(PoseStack var1, GhostBlockOptions var2);

    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ps, GhostBlockOptions options) {
            ps.m_85836_();
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            Minecraft minecraft = Minecraft.m_91087_();
            BlockRenderDispatcher dispatch = minecraft.m_91289_();
            BakedModel bakedModel = dispatch.m_110910_(options.blockState);
            RenderType renderType = options.renderType;
            VertexConsumer consumer = RenderHandler.DELAYED_RENDER.m_6299_(renderType);
            BlockPos pos = options.blockPos;
            float scale = options.scaleSupplier.get().floatValue();
            ps.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            ps.m_85837_(0.5, 0.5, 0.5);
            ps.m_85841_(scale, scale, scale);
            ps.m_85837_(-0.5, -0.5, -0.5);
            float alpha = options.alphaSupplier.get().floatValue();
            DefaultGhostBlockRenderer.renderModel(ps.m_85850_(), consumer, options.blockState, bakedModel, options.red, options.green, options.blue, alpha, LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)pos), OverlayTexture.f_118083_, ModelData.EMPTY, minecraft.f_91073_.m_213780_(), renderType);
            RenderSystem.m_69461_();
            RenderSystem.m_69465_();
            ps.m_85849_();
        }

        public static void renderModel(PoseStack.Pose pose, VertexConsumer consumer, BlockState state, BakedModel model, float red, float green, float blue, float alpha, int packedLight, int packedOverlay, ModelData extraData, RandomSource random, RenderType renderType) {
            for (Direction direction : Direction.values()) {
                random.m_188584_(42L);
                DefaultGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.getQuads(state, direction, random, extraData, renderType), packedLight, packedOverlay);
            }
            random.m_188584_(42L);
            DefaultGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.getQuads(state, null, random, extraData, renderType), packedLight, packedOverlay);
        }

        public static void renderQuadList(PoseStack.Pose pose, VertexConsumer consumer, float red, float green, float blue, float alpha, List<BakedQuad> quads, int packedLight, int packedOverlay) {
            for (BakedQuad quad : quads) {
                float r = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
                float g = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
                float b = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
                consumer.putBulkData(pose, quad, r, g, b, alpha, packedLight, packedOverlay, false);
            }
        }
    }
}

