/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.screenshake;

import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.screenshake.ScreenshakeInstance;

public class PositionedScreenshakeInstance
extends ScreenshakeInstance {
    public final Vec3 position;
    public final float falloffDistance;
    public final float maxDistance;
    public final Easing falloffEasing;

    public PositionedScreenshakeInstance(int duration, Vec3 position, float falloffDistance, float maxDistance, Easing falloffEasing) {
        super(duration);
        this.position = position;
        this.falloffDistance = falloffDistance;
        this.maxDistance = maxDistance;
        this.falloffEasing = falloffEasing;
    }

    public PositionedScreenshakeInstance(int duration, Vec3 position, float falloffDistance, float maxDistance) {
        this(duration, position, falloffDistance, maxDistance, Easing.LINEAR);
    }

    @Override
    public float updateIntensity(Camera camera, RandomSource random) {
        float intensity = super.updateIntensity(camera, random);
        float distance = (float)this.position.m_82554_(camera.m_90583_());
        if (distance > this.maxDistance) {
            return 0.0f;
        }
        float distanceMultiplier = 1.0f;
        if (distance > this.falloffDistance) {
            float remaining = this.maxDistance - this.falloffDistance;
            float current = distance - this.falloffDistance;
            distanceMultiplier = 1.0f - current / remaining;
        }
        Vector3f lookDirection = camera.m_90596_();
        Vec3 directionToScreenshake = this.position.m_82546_(camera.m_90583_()).m_82541_();
        float angle = Math.max(0.0f, lookDirection.m_122276_(new Vector3f(directionToScreenshake)));
        return (intensity * distanceMultiplier + intensity * angle) * 0.5f;
    }
}

