/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.worldevent;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.network.SyncWorldEventPacket;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;
import team.lodestar.lodestone.registry.common.LodestoneWorldEventTypeRegistry;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public abstract class WorldEventInstance {
    public UUID uuid = UUID.randomUUID();
    public WorldEventType type;
    public boolean discarded;

    public WorldEventInstance(WorldEventType type) {
        this.type = type;
    }

    public void sync(Level level) {
        if (!level.f_46443_ && this.isClientSynced()) {
            WorldEventInstance.sync(this);
        }
    }

    public boolean isClientSynced() {
        return false;
    }

    public void start(Level level) {
    }

    public void tick(Level level) {
    }

    public void end(Level level) {
        this.discarded = true;
    }

    public CompoundTag serializeNBT(CompoundTag tag) {
        tag.m_128362_("uuid", this.uuid);
        tag.m_128359_("type", this.type.id);
        tag.m_128379_("discarded", this.discarded);
        return tag;
    }

    public static <T extends WorldEventInstance> T deserializeDefaultWorldEventNBT(T instance, CompoundTag tag) {
        instance.uuid = tag.m_128342_("uuid");
        instance.type = LodestoneWorldEventTypeRegistry.EVENT_TYPES.get(tag.m_128461_("type"));
        instance.discarded = tag.m_128471_("discarded");
        return instance;
    }

    public static <T extends WorldEventInstance> void sync(T instance) {
        LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncWorldEventPacket(instance.type.id, true, instance.serializeNBT(new CompoundTag())));
    }

    public static <T extends WorldEventInstance> void sync(T instance, ServerPlayer player) {
        LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncWorldEventPacket(instance.type.id, false, instance.serializeNBT(new CompoundTag())));
    }
}

