/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.worldgen;

import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;

public class LodestoneBlockFiller {
    protected final HashMap<BlockPos, BlockStateEntry> entries = new HashMap();
    protected final boolean careful;

    public LodestoneBlockFiller(boolean careful) {
        this.careful = careful;
    }

    public void fill(LevelAccessor level) {
        this.getEntries().forEach((pos, entry) -> {
            if (!this.isCareful() || entry.canPlace(level, (BlockPos)pos)) {
                entry.place(level, (BlockPos)pos);
            }
        });
    }

    public void replace(BlockPos pos, Function<BlockStateEntry, BlockStateEntry> entryFunction) {
        this.getEntries().replace(pos, entryFunction.apply(this.getEntries().get(pos)));
    }

    public HashMap<BlockPos, BlockStateEntry> getEntries() {
        return this.entries;
    }

    public boolean isCareful() {
        return this.careful;
    }

    public static class BlockStateEntry {
        protected final BlockState state;

        public BlockStateEntry(BlockState state) {
            this.state = state;
        }

        public BlockState getState() {
            return this.state;
        }

        public boolean canPlace(LevelAccessor level, BlockPos pos) {
            if (level.m_151570_(pos)) {
                return false;
            }
            BlockState state = level.m_8055_(pos);
            return level.m_46859_(pos) || state.m_60767_().m_76336_();
        }

        public void place(LevelAccessor level, BlockPos pos) {
            level.m_7731_(pos, this.state, 19);
            if (level instanceof Level) {
                BlockStateHelper.updateState((Level)level, pos);
            }
        }
    }
}

