/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.entities;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.block.LootrBarrelBlock;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.init.ModBlockEntities;
import noobanidus.mods.lootr.util.Getter;

public class LootrBarrelBlockEntity
extends RandomizableContainerBlockEntity
implements ILootBlockEntity {
    public Set<UUID> openers = new HashSet<UUID>();
    protected ResourceLocation savedLootTable = null;
    protected long seed = -1L;
    protected UUID tileId = null;
    protected boolean opened = false;
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level leve, BlockPos pos, BlockState state) {
            LootrBarrelBlockEntity.this.playSound(state, SoundEvents.f_11725_);
            LootrBarrelBlockEntity.this.updateBlockState(state, true);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            LootrBarrelBlockEntity.this.playSound(state, SoundEvents.f_11724_);
            LootrBarrelBlockEntity.this.updateBlockState(state, false);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int p_155069_, int p_155070_) {
        }

        protected boolean m_142718_(Player player) {
            Container container;
            if (player.f_36096_ instanceof ChestMenu && (container = ((ChestMenu)player.f_36096_).m_39261_()) instanceof SpecialChestInventory) {
                SpecialChestInventory data = (SpecialChestInventory)container;
                return data.getTileId().equals(LootrBarrelBlockEntity.this.getTileId());
            }
            return false;
        }
    };
    private ModelData modelData = null;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);

    public LootrBarrelBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.LOOTR_BARREL.get(), pWorldPosition, pBlockState);
    }

    @Nonnull
    public ModelData getModelData() {
        Player player;
        if (this.modelData == null) {
            this.modelData = ModelData.builder().with(LootrBarrelBlock.OPENED, (Object)false).build();
        }
        if ((player = Getter.getPlayer()) != null) {
            return this.modelData.derive().with(LootrBarrelBlock.OPENED, (Object)this.openers.contains(player.m_20148_())).build();
        }
        return this.modelData;
    }

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    public void m_59626_(ResourceLocation lootTableIn, long seedIn) {
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
        super.m_59626_(lootTableIn, seedIn);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> pItems) {
    }

    public void m_59640_(@Nullable Player player) {
    }

    @Override
    public void unpackLootTable(Player player, Container inventory, @Nullable ResourceLocation overrideTable, long seed) {
        if (this.f_58857_ != null && this.savedLootTable != null && this.f_58857_.m_7654_() != null) {
            LootTable loottable = this.f_58857_.m_7654_().m_129898_().m_79217_(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == LootTable.f_79105_) {
                LootrAPI.LOG.error("Unable to fill loot barrel in " + this.f_58857_.m_46472_() + " at " + this.f_58858_ + " as the loot table '" + (overrideTable != null ? overrideTable : this.savedLootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237110_((String)"lootr.message.invalid_table", (Object[])new Object[]{(overrideTable != null ? overrideTable : this.savedLootTable).toString()}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED)).m_131136_(Boolean.valueOf(true))), false);
                }
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, overrideTable != null ? overrideTable : this.f_59605_);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_78965_((Boolean)ConfigManager.RANDOMISE_SEED.get() != false ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.seed : seed));
            if (player != null) {
                builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            }
            loottable.m_79123_(inventory, builder.m_78975_(LootContextParamSets.f_81411_));
        }
    }

    @Override
    public ResourceLocation getTable() {
        return this.savedLootTable;
    }

    @Override
    public BlockPos getPosition() {
        return this.m_58899_();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("specialLootChest_table", 8)) {
            this.savedLootTable = new ResourceLocation(compound.m_128461_("specialLootChest_table"));
        }
        if (compound.m_128425_("specialLootChest_seed", 4)) {
            this.seed = compound.m_128454_("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.m_128425_("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.m_128461_("LootTable"));
            if (compound.m_128425_("LootTableSeed", 4)) {
                this.seed = compound.m_128454_("LootTableSeed");
            }
            this.m_59626_(this.savedLootTable, this.seed);
        }
        if (compound.m_128403_("tileId")) {
            this.tileId = compound.m_128342_("tileId");
        } else if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.m_128441_("LootrOpeners")) {
            ListTag openers = compound.m_128437_("LootrOpeners", 11);
            this.openers.clear();
            for (Tag item : openers) {
                this.openers.add(NbtUtils.m_129233_((Tag)item));
            }
        }
        this.requestModelDataUpdate();
        super.m_142466_(compound);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.savedLootTable != null) {
            compound.m_128359_("specialLootBarrel_table", this.savedLootTable.toString());
            compound.m_128359_("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.m_128356_("specialLootBarrel_seed", this.seed);
            compound.m_128356_("LootTableSeed", this.seed);
        }
        compound.m_128362_("tileId", this.getTileId());
        ListTag list = new ListTag();
        for (UUID opener : this.openers) {
            list.add((Object)NbtUtils.m_129226_((UUID)opener));
        }
        compound.m_128365_("LootrOpeners", (Tag)list);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.barrel");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }

    public int m_6643_() {
        return 27;
    }

    public void m_5856_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void updateBlockState(BlockState pState, boolean pOpen) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)pState.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    protected void playSound(BlockState pState, SoundEvent pSound) {
        Vec3i vec3i = ((Direction)pState.m_61143_((Property)BarrelBlock.f_49042_)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    @Override
    public void updatePacketViaState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 8);
        }
    }

    @Override
    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag result = super.m_5995_();
        this.m_183515_(result);
        return result;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(@Nonnull Connection net, @Nonnull ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }
}

