/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.ModTags;
import mob_grinding_utils.inventory.server.ContainerMGUSpawner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMGUSpawner
extends BlockEntity
implements MenuProvider {
    public int spawning_progress = 0;
    public int MAX_SPAWNING_TIME = 100;
    public boolean isOn = false;
    public ItemStackHandler inputSlots = new ItemStackHandler(4);
    public ItemStackHandler fuelSlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41720_() == ModItems.SOLID_XP_BABY.get();
        }
    };
    private final LazyOptional<IItemHandler> fuelSlotCap = LazyOptional.of(() -> this.fuelSlot);
    public int animationTicks;
    public int prevAnimationTicks;
    public boolean showRenderBox;
    public int offsetX;
    public int offsetY;
    public int offsetZ;

    public TileEntityMGUSpawner(BlockPos pos, BlockState state) {
        super(ModBlocks.ENTITY_SPAWNER.getTileEntityType(), pos, state);
    }

    public void toggleOnOff() {
        this.isOn = !this.isOn;
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (t instanceof TileEntityMGUSpawner) {
            TileEntityMGUSpawner tile = (TileEntityMGUSpawner)t;
            if (tile.isOn) {
                if (tile.canOperate()) {
                    tile.setProgress(tile.getProgress() + 1 + tile.getSpeedModifierAmount());
                    if (tile.getProgress() >= tile.MAX_SPAWNING_TIME) {
                        if (tile.spawnMobInArea()) {
                            tile.fuelSlot.getStackInSlot(0).m_41774_(1);
                        }
                        tile.setProgress(0);
                    }
                } else if (tile.getProgress() > 0) {
                    tile.setProgress(0);
                }
            } else if (tile.getProgress() > 0) {
                tile.setProgress(0);
            }
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (t instanceof TileEntityMGUSpawner) {
            TileEntityMGUSpawner tile = (TileEntityMGUSpawner)t;
            if (tile.isOn) {
                tile.prevAnimationTicks = tile.animationTicks;
                if (tile.animationTicks < 360) {
                    tile.animationTicks += 9;
                }
                if (tile.animationTicks >= 360) {
                    tile.animationTicks -= 360;
                    tile.prevAnimationTicks -= 360;
                }
            } else {
                tile.animationTicks = 0;
                tile.prevAnimationTicks = 0;
            }
        }
    }

    private boolean spawnMobInArea() {
        EntityType type = null;
        ItemStack eggStack = this.inputSlots.getStackInSlot(0);
        SpawnEggItem eggItem = (SpawnEggItem)eggStack.m_41720_();
        type = eggItem.m_43228_(null);
        if (type != null && !type.m_204039_(ModTags.Entities.NO_SPAWN)) {
            AABB axisalignedbb = this.getAABBWithModifiers();
            int minX = Mth.m_14107_((double)axisalignedbb.f_82288_);
            int maxX = Mth.m_14107_((double)axisalignedbb.f_82291_);
            int minY = Mth.m_14107_((double)axisalignedbb.f_82289_);
            int maxY = Mth.m_14107_((double)axisalignedbb.f_82292_);
            int minZ = Mth.m_14107_((double)axisalignedbb.f_82290_);
            int maxZ = Mth.m_14107_((double)axisalignedbb.f_82293_);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            Mob entity = (Mob)type.m_20615_(this.m_58904_());
            ArrayList<BlockPos> posArrayList = new ArrayList<BlockPos>();
            if (entity != null) {
                for (int x = minX; x < maxX; ++x) {
                    for (int y = minY; y < maxY; ++y) {
                        for (int z = minZ; z < maxZ; ++z) {
                            mutablePos.m_122178_(x, y, z);
                            entity.m_6034_((double)mutablePos.m_123341_() + 0.5, (double)mutablePos.m_123342_(), (double)mutablePos.m_123343_() + 0.5);
                            if (!this.isValidSpawnLocation(this.m_58904_(), type, (Entity)entity, (BlockPos)mutablePos)) continue;
                            posArrayList.add(new BlockPos((Vec3i)mutablePos));
                        }
                    }
                }
                if (!posArrayList.isEmpty()) {
                    Collections.shuffle(posArrayList);
                    entity.m_6034_((double)((BlockPos)posArrayList.get(0)).m_123341_() + 0.5, (double)((BlockPos)posArrayList.get(0)).m_123342_(), (double)((BlockPos)posArrayList.get(0)).m_123343_() + 0.5);
                    entity.m_6518_((ServerLevelAccessor)this.m_58904_(), this.m_58904_().m_6436_((BlockPos)posArrayList.get(0)), MobSpawnType.SPAWNER, null, null);
                    this.m_58904_().m_7967_((Entity)entity);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isValidSpawnLocation(Level world, EntityType<?> type, Entity entity, BlockPos pos) {
        return NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.m_21752_(type), (LevelReader)world, (BlockPos)pos, type) && world.m_142425_((EntityTypeTest)entity.m_6095_(), entity.m_20191_(), EntitySelector.f_20402_).isEmpty() && this.m_58904_().m_45786_(entity);
    }

    public void toggleRenderBox() {
        this.showRenderBox = !this.showRenderBox;
        this.m_6596_();
    }

    public void toggleOffset(int direction) {
        switch (direction) {
            case 1: {
                if (this.getoffsetY() < -1 - this.getHeightModifierAmount()) break;
                this.offsetY = this.getoffsetY() - 1;
                break;
            }
            case 2: {
                if (this.getoffsetY() > 1 + this.getHeightModifierAmount()) break;
                this.offsetY = this.getoffsetY() + 1;
                break;
            }
            case 3: {
                if (this.getoffsetZ() < -1 - this.getWidthModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() - 1;
                break;
            }
            case 4: {
                if (this.getoffsetZ() > 1 + this.getWidthModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() + 1;
                break;
            }
            case 5: {
                if (this.getoffsetX() < -1 - this.getWidthModifierAmount()) break;
                this.offsetX = this.getoffsetX() - 1;
                break;
            }
            case 6: {
                if (this.getoffsetX() > 1 + this.getWidthModifierAmount()) break;
                this.offsetX = this.getoffsetX() + 1;
            }
        }
        this.m_6596_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int count) {
        return this.getProgress() * count / this.MAX_SPAWNING_TIME;
    }

    private boolean canOperate() {
        return this.hasSpawnEggItem() && this.hasFuel();
    }

    public boolean hasSpawnEggItem() {
        return !this.inputSlots.getStackInSlot(0).m_41619_() && this.inputSlots.getStackInSlot(0).m_41720_() instanceof SpawnEggItem;
    }

    private boolean hasFuel() {
        return !this.fuelSlot.getStackInSlot(0).m_41619_() && this.fuelSlot.getStackInSlot(0).m_41720_() == ModItems.SOLID_XP_BABY.get();
    }

    private boolean hasWidthUpgrade() {
        return !this.inputSlots.getStackInSlot(1).m_41619_() && this.inputSlots.getStackInSlot(1).m_41720_() == ModItems.SPAWNER_UPGRADE_WIDTH.get();
    }

    public int getWidthModifierAmount() {
        return this.hasWidthUpgrade() ? this.inputSlots.getStackInSlot(1).m_41613_() : 0;
    }

    private boolean hasHeightUpgrade() {
        return !this.inputSlots.getStackInSlot(2).m_41619_() && this.inputSlots.getStackInSlot(2).m_41720_() == ModItems.SPAWNER_UPGRADE_HEIGHT.get();
    }

    public int getHeightModifierAmount() {
        return this.hasHeightUpgrade() ? this.inputSlots.getStackInSlot(2).m_41613_() : 0;
    }

    private boolean hasSpeedUpgrade() {
        return !this.inputSlots.getStackInSlot(3).m_41619_() && this.inputSlots.getStackInSlot(3).m_41720_() == ModItems.XP_SOLIDIFIER_UPGRADE.get();
    }

    public int getSpeedModifierAmount() {
        return this.hasSpeedUpgrade() ? this.inputSlots.getStackInSlot(3).m_41613_() : 0;
    }

    public AABB getAABBWithModifiers() {
        double x = (double)this.m_58899_().m_123341_() + 0.5;
        double y = (double)this.m_58899_().m_123342_() + 0.5;
        double z = (double)this.m_58899_().m_123343_() + 0.5;
        return new AABB(x - 1.5 - (double)this.getWidthModifierAmount(), y - 0.5 - (double)this.getHeightModifierAmount(), z - 1.5 - (double)this.getWidthModifierAmount(), x + 1.5 + (double)this.getWidthModifierAmount(), y + 0.5 + (double)this.getHeightModifierAmount(), z + 1.5 + (double)this.getWidthModifierAmount()).m_82386_((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getAABBForRender() {
        return new AABB(-1.0 - (double)this.getWidthModifierAmount(), -0.0 - (double)this.getHeightModifierAmount(), -1.0 - (double)this.getWidthModifierAmount(), 2.0 + (double)this.getWidthModifierAmount(), 1.0 + (double)this.getHeightModifierAmount(), 2.0 + (double)this.getWidthModifierAmount()).m_82386_((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return this.getAABBWithModifiers();
    }

    public int getoffsetX() {
        return Math.max(-2 - this.getWidthModifierAmount(), Math.min(this.offsetX, 2 + this.getWidthModifierAmount()));
    }

    public int getoffsetY() {
        return Math.max(-1 - this.getHeightModifierAmount(), Math.min(this.offsetY, 1 + this.getHeightModifierAmount()));
    }

    public int getoffsetZ() {
        return Math.max(-2 - this.getWidthModifierAmount(), Math.min(this.offsetZ, 2 + this.getWidthModifierAmount()));
    }

    private void setProgress(int counter) {
        this.spawning_progress = counter;
        this.updateBlock();
    }

    public int getProgress() {
        return this.spawning_progress;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inputSlots.deserializeNBT(nbt.m_128469_("inputSlots"));
        this.fuelSlot.deserializeNBT(nbt.m_128469_("fuelSlot"));
        this.isOn = nbt.m_128471_("isOn");
        this.showRenderBox = nbt.m_128471_("showRenderBox");
        this.offsetX = nbt.m_128451_("offsetX");
        this.offsetY = nbt.m_128451_("offsetY");
        this.offsetZ = nbt.m_128451_("offsetZ");
        this.spawning_progress = nbt.m_128451_("spawning_progress");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inputSlots", (Tag)this.inputSlots.serializeNBT());
        nbt.m_128365_("fuelSlot", (Tag)this.fuelSlot.serializeNBT());
        nbt.m_128379_("isOn", this.isOn);
        nbt.m_128379_("showRenderBox", this.showRenderBox);
        nbt.m_128405_("offsetX", this.offsetX);
        nbt.m_128405_("offsetY", this.offsetY);
        nbt.m_128405_("offsetZ", this.offsetZ);
        nbt.m_128405_("spawning_progress", this.spawning_progress);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.m_142466_(packet.m_131708_());
    }

    public void updateBlock() {
        this.m_58904_().m_7260_(this.f_58858_, this.m_58904_().m_8055_(this.f_58858_), this.m_58904_().m_8055_(this.f_58858_), 3);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.mob_grinding_utils.entity_spawner");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInventory, Player player) {
        return new ContainerMGUSpawner(windowID, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getEntityToRender() {
        Entity entity = null;
        if (this.hasSpawnEggItem()) {
            ItemStack eggStack = this.inputSlots.getStackInSlot(0);
            SpawnEggItem eggItem = (SpawnEggItem)eggStack.m_41720_();
            entity = eggItem.m_43228_(null).m_20615_(this.m_58904_());
        }
        return entity;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.fuelSlotCap.cast();
        }
        return super.getCapability(cap, side);
    }
}

