/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.logging.LoggerAdapterDefault;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.service.MixinServiceAbstract;

public class ClassInfoManager {
    private static boolean hasRun = false;
    private static final List<Runnable> loggersToRestore = new ArrayList<Runnable>();

    public static void clear() {
        if (!ModernFixMixinPlugin.instance.isOptionEnabled("perf.clear_mixin_classinfo.ClassInfoManager") || hasRun) {
            return;
        }
        hasRun = true;
        ModernFix.resourceReloadExecutor().execute(ClassInfoManager::doClear);
    }

    private static Field accessible(Field f) {
        f.setAccessible(true);
        return f;
    }

    private static void changeLoggerAndRestoreLater(Map<String, ILogger> map, ILogger newLogger) {
        ILogger oldLogger = map.put("mixin.audit", newLogger);
        loggersToRestore.add(() -> map.put("mixin.audit", oldLogger));
    }

    private static void disableLoggers() throws ReflectiveOperationException {
        Field loggersField = ClassInfoManager.accessible(MixinServiceAbstract.class.getDeclaredField("loggers"));
        ClassInfoManager.changeLoggerAndRestoreLater((Map)loggersField.get(null), (ILogger)new LoggerAdapterDefault("mixin.audit"));
        Class<?> fabricLogger = null;
        try {
            fabricLogger = Class.forName("net.fabricmc.loader.impl.knot.MixinLogger");
        }
        catch (Throwable e) {
            return;
        }
        loggersField = ClassInfoManager.accessible(fabricLogger.getDeclaredField("LOGGER_MAP"));
        ClassInfoManager.changeLoggerAndRestoreLater((Map)loggersField.get(null), (ILogger)new LoggerAdapterDefault("mixin.audit"));
    }

    private static void doClear() {
        Field classNodeField;
        Field stateField;
        Field fieldsField;
        Field methodsField;
        Field mixinField;
        Map classInfoCache;
        try {
            ClassInfoManager.disableLoggers();
            Field field = ClassInfoManager.accessible(ClassInfo.class.getDeclaredField("cache"));
            classInfoCache = (Map)field.get(null);
            mixinField = ClassInfoManager.accessible(ClassInfo.class.getDeclaredField("mixin"));
            methodsField = ClassInfoManager.accessible(ClassInfo.class.getDeclaredField("methods"));
            fieldsField = ClassInfoManager.accessible(ClassInfo.class.getDeclaredField("fields"));
            Class<?> stateClz = Class.forName("org.spongepowered.asm.mixin.transformer.MixinInfo$State");
            stateField = ClassInfoManager.accessible(Class.forName("org.spongepowered.asm.mixin.transformer.MixinInfo").getDeclaredField("state"));
            classNodeField = ClassInfoManager.accessible(stateClz.getDeclaredField("classNode"));
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            e.printStackTrace();
            return;
        }
        MixinEnvironment.getDefaultEnvironment().audit();
        try {
            ClassNode emptyNode = new ClassNode();
            classInfoCache.entrySet().removeIf(entry -> {
                if (((String)entry.getKey()).equals("java/lang/Object")) {
                    return false;
                }
                ClassInfo mixinClz = (ClassInfo)entry.getValue();
                if (mixinClz == null) {
                    return true;
                }
                try {
                    IMixinInfo theInfo;
                    Object state;
                    if (mixinClz.isMixin() && (state = stateField.get(theInfo = (IMixinInfo)mixinField.get(mixinClz))) != null) {
                        classNodeField.set(state, emptyNode);
                    }
                    ((Collection)methodsField.get(mixinClz)).clear();
                    ((Collection)fieldsField.get(mixinClz)).clear();
                }
                catch (ReflectiveOperationException | RuntimeException e) {
                    e.printStackTrace();
                }
                return true;
            });
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        loggersToRestore.forEach(Runnable::run);
        loggersToRestore.clear();
        ModernFix.LOGGER.warn("Cleared mixin data structures");
    }
}

