/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateMatcher
implements StateMatcher {
    public static final ResourceLocation TYPE = Modonomicon.loc("blockstate");
    private final BlockState displayState;
    private final BlockState blockState;
    private final TriPredicate<BlockGetter, BlockPos, BlockState> predicate;

    protected BlockStateMatcher(BlockState displayState, BlockState blockState) {
        this.displayState = displayState;
        this.blockState = blockState;
        this.predicate = (blockGetter, blockPos, state) -> state == blockState;
    }

    public static BlockStateMatcher from(BlockState blockState) {
        return new BlockStateMatcher(null, blockState);
    }

    public static BlockStateMatcher from(BlockState displayState, BlockState blockState) {
        return new BlockStateMatcher(displayState, blockState);
    }

    public static BlockStateMatcher fromJson(JsonObject json) {
        BlockState displayState = null;
        if (json.has("display")) {
            try {
                displayState = BlockStateParser.m_234700_((Registry)Registry.f_122824_, (StringReader)new StringReader(GsonHelper.m_13906_((JsonObject)json, (String)"display")), (boolean)false).f_234748_();
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for BlockStateMatcher.", e);
            }
        }
        try {
            BlockState blockState = BlockStateParser.m_234700_((Registry)Registry.f_122824_, (StringReader)new StringReader(GsonHelper.m_13906_((JsonObject)json, (String)"block")), (boolean)false).f_234748_();
            return new BlockStateMatcher(displayState, blockState);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockState from json member \"block\" for BlockStateMatcher.", e);
        }
    }

    public static BlockStateMatcher fromNetwork(FriendlyByteBuf buffer) {
        try {
            BlockState displayState = null;
            if (buffer.readBoolean()) {
                displayState = BlockStateParser.m_234700_((Registry)Registry.f_122824_, (StringReader)new StringReader(buffer.m_130277_()), (boolean)false).f_234748_();
            }
            BlockState blockState = BlockStateParser.m_234700_((Registry)Registry.f_122824_, (StringReader)new StringReader(buffer.m_130277_()), (boolean)false).f_234748_();
            return new BlockStateMatcher(displayState, blockState);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockStateMatcher from network.", e);
        }
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public BlockState getDisplayedState(long ticks) {
        return this.displayState == null ? this.blockState : this.displayState;
    }

    @Override
    public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.displayState != null);
        if (this.displayState != null) {
            buffer.m_130070_(BlockStateParser.m_116769_((BlockState)this.displayState));
        }
        buffer.m_130070_(BlockStateParser.m_116769_((BlockState)this.blockState));
    }

    public int hashCode() {
        return Objects.hash(this.blockState, this.displayState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockStateMatcher that = (BlockStateMatcher)o;
        return this.blockState.equals(that.blockState) && this.displayState.equals(that.displayState);
    }
}

