/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import me.desht.modularrouters.client.gui.module.AbstractModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.logic.compiled.CompiledActivatorModule;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ActivatorModuleScreen
extends AbstractModuleScreen {
    private static final ItemStack ITEM_STACK = new ItemStack((ItemLike)Items.f_42409_);
    private static final ItemStack ENTITY_STACK = new ItemStack((ItemLike)Items.f_42680_);
    private static final ItemStack ATTACK_STACK = new ItemStack((ItemLike)Items.f_42383_);
    private LookDirectionButton lookDirectionButton;
    private ActionTypeButton actionTypeButton;
    private EntityModeButton entityModeButton;
    private SneakButton sneakButton;

    public ActivatorModuleScreen(ModuleMenu container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        CompiledActivatorModule cam = new CompiledActivatorModule(null, this.moduleItemStack);
        ItemStack[] stacks = new ItemStack[]{ITEM_STACK, ENTITY_STACK, ATTACK_STACK};
        this.actionTypeButton = new ActionTypeButton(this.f_97735_ + 167, this.f_97736_ + 20, 16, 16, true, stacks, cam.getActionType());
        this.m_142416_((GuiEventListener)this.actionTypeButton);
        this.sneakButton = new SneakButton(this.f_97735_ + 167, this.f_97736_ + 40, cam.isSneaking());
        this.m_142416_((GuiEventListener)this.sneakButton);
        this.lookDirectionButton = new LookDirectionButton(this.f_97735_ + 167, this.f_97736_ + 60, 16, 16, cam.getLookDirection());
        this.m_142416_((GuiEventListener)this.lookDirectionButton);
        this.entityModeButton = new EntityModeButton(this.f_97735_ + 167, this.f_97736_ + 60, 16, 16, cam.getEntityMode());
        this.m_142416_((GuiEventListener)this.entityModeButton);
        this.lookDirectionButton.f_93624_ = !cam.getActionType().isEntityTarget();
        this.entityModeButton.f_93624_ = cam.getActionType().isEntityTarget();
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 130, this.f_97736_ + 18, this.f_97735_ + 183, this.f_97736_ + 37, "modularrouters.guiText.popup.activator.action");
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 130, this.f_97736_ + 39, this.f_97735_ + 183, this.f_97736_ + 56, "modularrouters.guiText.popup.activator.sneak");
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 130, this.f_97736_ + 59, this.f_97735_ + 183, this.f_97736_ + 76, "modularrouters.guiText.popup.activator.look", guiContainer -> this.lookDirectionButton.f_93624_);
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 130, this.f_97736_ + 59, this.f_97735_ + 183, this.f_97736_ + 76, "modularrouters.guiText.popup.activator.look", guiContainer -> this.entityModeButton.f_93624_);
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.m_93228_(matrixStack, this.f_97735_ + 165, this.f_97736_ + 19, BUTTON_XY.x(), BUTTON_XY.y(), 18, 18);
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.f_96547_.m_92889_(matrixStack, (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.action", new Object[0]), 132.0f, 23.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.sneak", new Object[0]), 132.0f, 43.0f, 0x404040);
        if (((CompiledActivatorModule.ActionType)this.actionTypeButton.getState()).isEntityTarget()) {
            this.f_96547_.m_92889_(matrixStack, (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.entityMode", new Object[0]), 132.0f, 63.0f, 0x404040);
        } else {
            this.f_96547_.m_92889_(matrixStack, (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.lookDirection", new Object[0]), 132.0f, 63.0f, 0x404040);
        }
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.lookDirectionButton.f_93624_ = !((CompiledActivatorModule.ActionType)this.actionTypeButton.getState()).isEntityTarget();
        this.entityModeButton.f_93624_ = ((CompiledActivatorModule.ActionType)this.actionTypeButton.getState()).isEntityTarget();
    }

    @Override
    protected CompoundTag buildMessageData() {
        CompoundTag compound = super.buildMessageData();
        compound.m_128405_("ActionType2", ((CompiledActivatorModule.ActionType)this.actionTypeButton.getState()).ordinal());
        compound.m_128405_("LookDirection", ((CompiledActivatorModule.LookDirection)this.lookDirectionButton.getState()).ordinal());
        compound.m_128405_("EntityMode", ((CompiledActivatorModule.EntityMode)this.entityModeButton.getState()).ordinal());
        compound.m_128379_("Sneaking", this.sneakButton.isToggled());
        return compound;
    }

    private class ActionTypeButton
    extends ItemStackCyclerButton<CompiledActivatorModule.ActionType> {
        private final Map<CompiledActivatorModule.ActionType, List<Component>> tooltips;

        ActionTypeButton(int x, int y, int width, int height, boolean flat, ItemStack[] stacks, CompiledActivatorModule.ActionType initialVal) {
            super(x, y, width, height, flat, stacks, initialVal, ActivatorModuleScreen.this);
            this.tooltips = new EnumMap<CompiledActivatorModule.ActionType, List<Component>>(CompiledActivatorModule.ActionType.class);
            for (CompiledActivatorModule.ActionType actionType : CompiledActivatorModule.ActionType.values()) {
                this.tooltips.put(actionType, Collections.singletonList(ClientUtil.xlate(actionType.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        public List<Component> getTooltip() {
            return this.tooltips.get(this.getState());
        }
    }

    private class SneakButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(112, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(192, 16);

        SneakButton(int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, ActivatorModuleScreen.this);
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }

    private class LookDirectionButton
    extends TexturedCyclerButton<CompiledActivatorModule.LookDirection> {
        private final Map<CompiledActivatorModule.LookDirection, List<Component>> tooltips;

        LookDirectionButton(int x, int y, int width, int height, CompiledActivatorModule.LookDirection initialVal) {
            super(x, y, width, height, initialVal, ActivatorModuleScreen.this);
            this.tooltips = new EnumMap<CompiledActivatorModule.LookDirection, List<Component>>(CompiledActivatorModule.LookDirection.class);
            for (CompiledActivatorModule.LookDirection dir : CompiledActivatorModule.LookDirection.values()) {
                this.tooltips.put(dir, Collections.singletonList(ClientUtil.xlate(dir.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(144 + ((CompiledActivatorModule.LookDirection)this.getState()).ordinal() * 16, 0);
        }

        @Override
        public List<Component> getTooltip() {
            return this.tooltips.get(this.getState());
        }
    }

    private class EntityModeButton
    extends TexturedCyclerButton<CompiledActivatorModule.EntityMode> {
        private final List<List<Component>> tooltips;

        EntityModeButton(int x, int y, int width, int height, CompiledActivatorModule.EntityMode initialVal) {
            super(x, y, width, height, initialVal, ActivatorModuleScreen.this);
            this.tooltips = Lists.newArrayList();
            for (CompiledActivatorModule.EntityMode mode : CompiledActivatorModule.EntityMode.values()) {
                this.tooltips.add(Collections.singletonList(ClientUtil.xlate(mode.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        protected XYPoint getTextureXY() {
            int x = switch ((CompiledActivatorModule.EntityMode)this.getState()) {
                default -> throw new IncompatibleClassChangeError();
                case CompiledActivatorModule.EntityMode.RANDOM -> 176;
                case CompiledActivatorModule.EntityMode.NEAREST -> 192;
                case CompiledActivatorModule.EntityMode.ROUND_ROBIN -> 160;
            };
            int y = switch ((CompiledActivatorModule.EntityMode)this.getState()) {
                default -> throw new IncompatibleClassChangeError();
                case CompiledActivatorModule.EntityMode.RANDOM, CompiledActivatorModule.EntityMode.ROUND_ROBIN -> 32;
                case CompiledActivatorModule.EntityMode.NEAREST -> 16;
            };
            return new XYPoint(x, y);
        }

        @Override
        public List<Component> getTooltip() {
            return this.tooltips.get(((CompiledActivatorModule.EntityMode)this.getState()).ordinal());
        }
    }
}

