/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryUtils {
    public static void dropInventoryItems(Level world, BlockPos pos, IItemHandler itemHandler) {
        Random random = new Random();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack = itemHandler.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            float offsetX = random.nextFloat() * 0.8f + 0.1f;
            float offsetY = random.nextFloat() * 0.8f + 0.1f;
            float offsetZ = random.nextFloat() * 0.8f + 0.1f;
            while (!itemStack.m_41619_()) {
                int stackSize = Math.min(itemStack.m_41613_(), random.nextInt(21) + 10);
                ItemEntity entityitem = new ItemEntity(world, (double)pos.m_123341_() + (double)offsetX, (double)pos.m_123342_() + (double)offsetY, (double)pos.m_123343_() + (double)offsetZ, new ItemStack((ItemLike)itemStack.m_41720_(), stackSize));
                if (itemStack.m_41782_()) {
                    entityitem.m_32055_().m_41751_(Objects.requireNonNull(itemStack.m_41783_()).m_6426_());
                }
                itemStack.m_41774_(stackSize);
                float motionScale = 0.05f;
                entityitem.m_20334_(random.nextGaussian() * (double)motionScale, random.nextGaussian() * (double)motionScale + 0.2, random.nextGaussian() * (double)motionScale);
                world.m_7967_((Entity)entityitem);
            }
        }
    }

    public static LazyOptional<IItemHandler> getInventory(Level world, BlockPos pos, @Nullable Direction side) {
        BlockEntity te = world.m_7702_(pos);
        return te == null ? LazyOptional.empty() : te.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
    }

    public static int transferItems(IItemHandler from, IItemHandler to, int slot, int count) {
        if (from == null || to == null || count == 0) {
            return 0;
        }
        ItemStack toSend = from.extractItem(slot, count, true);
        if (toSend.m_41619_()) {
            return 0;
        }
        ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)toSend, (boolean)false);
        int inserted = toSend.m_41613_() - excess.m_41613_();
        from.extractItem(slot, inserted, false);
        return inserted;
    }

    public static boolean dropItems(Level world, Vec3 pos, ItemStack stack) {
        if (!world.f_46443_) {
            ItemEntity item = new ItemEntity(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), stack);
            return world.m_7967_((Entity)item);
        }
        return true;
    }

    public static int countItems(ItemStack toCount, IItemHandler handler, int max, boolean matchMeta) {
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            boolean match;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            boolean bl = match = matchMeta ? stack.m_41656_(toCount) : stack.m_41726_(toCount);
            if (match) {
                count += stack.m_41613_();
            }
            if (count < max) continue;
            return max;
        }
        return count;
    }
}

