/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.gui.config;

import at.ridgo8.moreoverlays.MoreOverlays;
import at.ridgo8.moreoverlays.gui.ConfigScreen;
import at.ridgo8.moreoverlays.gui.config.OptionBoolean;
import at.ridgo8.moreoverlays.gui.config.OptionCategory;
import at.ridgo8.moreoverlays.gui.config.OptionGeneric;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigOptionList
extends ContainerObjectSelectionList<OptionEntry> {
    public static final String UNDO_CHAR = "\u21b6";
    public static final String RESET_CHAR = "\u2604";
    public static final String VALID = "\u2714";
    public static final String INVALID = "\u2715";
    private static final int ITEM_HEIGHT = 22;
    private final ConfigScreen parent;
    private final String modId;
    private ForgeConfigSpec rootConfig;
    private List<String> configPath = Collections.emptyList();
    private Map<String, Object> currentMap;
    private CommentedConfig comments;

    public ConfigOptionList(Minecraft minecraft, String modId, ConfigScreen configs) {
        super(minecraft, configs.f_96543_, configs.f_96544_, 43, configs.f_96544_ - 32, 22);
        this.parent = configs;
        this.modId = modId;
    }

    public static List<String> splitPath(String path) {
        return Arrays.asList(path.split("\\."));
    }

    public ConfigScreen getScreen() {
        return this.parent;
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 64;
    }

    public void updateGui() {
        this.m_93437_(this.parent.f_96543_, this.parent.f_96544_, 43, this.parent.f_96544_ - 32);
    }

    protected void m_7415_(PoseStack matrixStack, int p_renderDecorations_1_, int p_renderDecorations_2_) {
        int i = this.m_5773_();
        for (int j = 0; j < i; ++j) {
            int k = this.m_7610_(j);
            int l = this.m_7610_(j) + 22;
            if (l < this.f_93390_ || k > this.f_93391_) continue;
            OptionEntry e = (OptionEntry)this.m_93500_(j);
            e.runRenderTooltip(matrixStack);
        }
    }

    public String categoryTitleKey(List<String> path) {
        if (path.isEmpty()) {
            return null;
        }
        return "config." + this.modId + ".category." + path.stream().collect(Collectors.joining("."));
    }

    public void setConfiguration(ForgeConfigSpec rootConfig) {
        this.setConfiguration(rootConfig, Collections.emptyList());
    }

    public void setConfiguration(ForgeConfigSpec rootConfig, List<String> path) {
        this.rootConfig = rootConfig;
        try {
            Field forgeconfigspec_childconfig = ForgeConfigSpec.class.getDeclaredField("childConfig");
            forgeconfigspec_childconfig.setAccessible(true);
            Object childConfig_raw = forgeconfigspec_childconfig.get(rootConfig);
            if (childConfig_raw instanceof CommentedConfig) {
                this.comments = (CommentedConfig)childConfig_raw;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            MoreOverlays.logger.warn("Couldn't reflect childConfig from ForgeConfigSpec! Comments will be missing.", (Throwable)e);
        }
        this.updatePath(path);
    }

    private void setPath(List<String> path) {
        Object val = path.isEmpty() ? this.rootConfig.getValues() : this.rootConfig.getValues().getRaw(path);
        if (!(val instanceof UnmodifiableConfig)) {
            int n = path.size();
            if (n > 1 && path.get(n - 1) == path.get(n - 2)) {
                MoreOverlays.logger.error("Attempting to load duplicate path:", path);
                MoreOverlays.logger.warn("This could be caused by key event race condition");
                path.remove(n - 1);
                this.setPath(path);
                return;
            }
            throw new IllegalArgumentException("Path in config list has to point to another config object");
        }
        this.configPath = path;
        this.currentMap = val.valueMap();
        this.refreshEntries();
        this.parent.updatePath(this.getCurrentPath());
    }

    public void updatePath(List<String> path) {
        this.setPath(new ArrayList<String>(path));
    }

    public void push(String path) {
        this.push(ConfigOptionList.splitPath(path));
    }

    public void push(List<String> path) {
        ArrayList<String> tmp = new ArrayList<String>(this.configPath.size() + path.size());
        tmp.addAll(this.configPath);
        tmp.addAll(path);
        this.setPath(tmp);
    }

    public void pop() {
        this.pop(1);
    }

    public void pop(int amount) {
        ArrayList<String> tmp = new ArrayList<String>(this.configPath);
        for (int i = 0; i < amount && !tmp.isEmpty(); ++i) {
            tmp.remove(tmp.size() - 1);
        }
        this.setPath(tmp);
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        boolean flag = super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        OptionEntry selected = (OptionEntry)this.m_93412_(p_mouseClicked_1_, p_mouseClicked_3_);
        for (OptionEntry entry : this.m_6702_()) {
            if (entry == selected) continue;
            entry.m_7522_(null);
        }
        return flag;
    }

    public void refreshEntries() {
        this.m_93516_();
        for (Map.Entry<String, Object> cEntry : this.currentMap.entrySet()) {
            ArrayList<String> fullPath = new ArrayList<String>(this.configPath.size() + 1);
            fullPath.addAll(this.configPath);
            fullPath.add(cEntry.getKey());
            String comment = null;
            if (this.comments != null) {
                comment = this.comments.getComment(fullPath);
            }
            if (cEntry.getValue() instanceof UnmodifiableConfig) {
                String name = I18n.m_118938_((String)this.categoryTitleKey(fullPath), (Object[])new Object[0]);
                this.m_7085_((AbstractSelectionList.Entry)new OptionCategory(this, Arrays.asList(cEntry.getKey()), name, comment));
                continue;
            }
            if (cEntry.getValue() instanceof ForgeConfigSpec.BooleanValue) {
                this.m_7085_((AbstractSelectionList.Entry)new OptionBoolean(this, (ForgeConfigSpec.BooleanValue)cEntry.getValue(), (ForgeConfigSpec.ValueSpec)this.rootConfig.getSpec().get(fullPath)));
                continue;
            }
            this.m_7085_((AbstractSelectionList.Entry)new OptionGeneric(this, (ForgeConfigSpec.ConfigValue)cEntry.getValue(), (ForgeConfigSpec.ValueSpec)this.rootConfig.getSpec().get(fullPath)));
        }
        this.m_7522_(null);
    }

    public List<String> getCurrentPath() {
        return Collections.unmodifiableList(this.configPath);
    }

    public ForgeConfigSpec getConfig() {
        return this.rootConfig;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isSaveable() {
        boolean hasChanges = false;
        for (OptionEntry entry : this.m_6702_()) {
            if (!entry.isValid()) {
                return false;
            }
            hasChanges = hasChanges || entry.hasChanges();
        }
        return hasChanges;
    }

    public boolean isResettable() {
        boolean resettable = false;
        for (OptionEntry entry : this.m_6702_()) {
            resettable = resettable || entry.isResettable();
        }
        return resettable;
    }

    public boolean isUndoable() {
        boolean hasChanges = false;
        for (OptionEntry entry : this.m_6702_()) {
            hasChanges = hasChanges || entry.hasChanges();
        }
        return hasChanges;
    }

    public void reset() {
        for (OptionEntry entry : this.m_6702_()) {
            entry.reset();
        }
    }

    public void undo() {
        for (OptionEntry entry : this.m_6702_()) {
            entry.undo();
        }
    }

    public void save() {
        for (OptionEntry entry : this.m_6702_()) {
            if (!entry.isValid()) continue;
            entry.save();
        }
    }

    public static abstract class OptionEntry
    extends ContainerObjectSelectionList.Entry<OptionEntry>
    implements ContainerEventHandler {
        private final ConfigOptionList optionList;
        protected int rowTop;
        protected int rowLeft;
        private int rowWidth;
        private int itemHeight;
        private int mouseX;
        private int mouseY;
        private boolean mouseOver;

        public OptionEntry(ConfigOptionList list) {
            this.optionList = list;
        }

        public void m_6311_(PoseStack matrixStack, int itemindex, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
            this.rowTop = rowTop;
            this.rowLeft = rowLeft;
            this.rowWidth = rowWidth;
            this.itemHeight = itemHeight;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.mouseOver = mouseOver;
            matrixStack.m_85837_((double)rowLeft, (double)rowTop, 0.0);
            this.renderControls(matrixStack, rowTop, rowLeft, rowWidth, itemHeight, mouseX -= rowLeft, mouseY -= rowTop, mouseOver, partialTick);
            matrixStack.m_85837_((double)(-rowLeft), (double)(-rowTop), 0.0);
        }

        protected abstract void renderControls(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public void runRenderTooltip(PoseStack matrixStack) {
            if (this.mouseOver) {
                this.renderTooltip(matrixStack, this.rowTop, this.rowLeft, this.rowWidth, this.itemHeight, this.mouseX, this.mouseY);
                Lighting.m_84930_();
                GlStateManager.m_84519_();
            }
        }

        protected void renderTooltip(PoseStack matrixStack, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY) {
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public ConfigOptionList getConfigOptionList() {
            return this.optionList;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return super.m_6375_(mouseX - (double)this.rowLeft, mouseY - (double)this.rowTop, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return super.m_6348_(mouseX - (double)this.rowLeft, mouseY - (double)this.rowTop, button);
        }

        public boolean m_7979_(double fromX, double fromY, int button, double toX, double toY) {
            return super.m_7979_(fromX - (double)this.rowLeft, fromY - (double)this.rowTop, button, toX - (double)this.rowLeft, toY - (double)this.rowTop);
        }

        public boolean m_7282_() {
            return false;
        }

        public void m_7897_(boolean dragging) {
        }

        public boolean m_6050_(double mouseX, double mouseY, double amount) {
            return super.m_6050_(mouseX - (double)this.rowLeft, mouseY - (double)this.rowTop, amount);
        }

        public boolean isValid() {
            return true;
        }

        public boolean hasChanges() {
            return false;
        }

        public boolean isResettable() {
            return false;
        }

        public void reset() {
        }

        public void undo() {
        }

        public void save() {
        }
    }
}

