/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.varia.Tools;

public class PotionWand
extends GenericWand {
    public PotionWand() {
        this.usageFactor(2.0f);
    }

    private String getEffectName(MobEffectInstance potioneffect) {
        Object s1 = I18n.m_118938_((String)potioneffect.m_19576_(), (Object[])new Object[0]).trim();
        if (potioneffect.m_19564_() > 0) {
            s1 = (String)s1 + " " + I18n.m_118938_((String)("potion.potency." + potioneffect.m_19564_()), (Object[])new Object[0]).trim();
        }
        if (potioneffect.m_19557_() > 20) {
            // empty if block
        }
        return s1;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flagIn) {
        super.m_7373_(stack, world, list, flagIn);
        list.add((Component)ComponentFactory.literal((String)"Left click on creature to apply effect"));
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "No effects. Combine with potion")));
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "in crafting table to add effect")));
            return;
        }
        ListTag effects = (ListTag)tagCompound.m_128423_("effects");
        if (effects == null || effects.isEmpty()) {
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "No effects. Combine with potion")));
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "in crafting table to add effect")));
            return;
        }
        list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "Combine with empty bottle")));
        list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "to clear effects")));
        int mode = this.getMode(stack);
        for (int i = 0; i < effects.size(); ++i) {
            CompoundTag effecttag = effects.m_128728_(i);
            MobEffectInstance effect = MobEffectInstance.m_19560_((CompoundTag)effecttag);
            if (i == mode) {
                list.add((Component)ComponentFactory.literal((String)("    + " + ChatFormatting.GREEN + this.getEffectName(effect))));
                continue;
            }
            list.add((Component)ComponentFactory.literal((String)("    " + ChatFormatting.GRAY + this.getEffectName(effect))));
        }
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        int mode = this.getMode(stack);
        ++mode;
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            return;
        }
        ListTag effects = (ListTag)tagCompound.m_128423_("effects");
        if (effects == null || effects.isEmpty()) {
            return;
        }
        if (mode >= effects.size()) {
            mode = 0;
        }
        CompoundTag effecttag = effects.m_128728_(mode);
        MobEffectInstance effect = MobEffectInstance.m_19560_((CompoundTag)effecttag);
        Tools.notify(player, ComponentFactory.literal((String)("Switched to " + this.getEffectName(effect) + " mode")));
        stack.m_41784_().m_128405_("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return stack.m_41784_().m_128451_("mode");
    }

    private void addeffect(LivingEntity entity, ItemStack wand, Player player) {
        CompoundTag tagCompound = wand.m_41783_();
        if (tagCompound == null) {
            Tools.error(player, "There are no effects in this wand!");
            return;
        }
        ListTag effects = (ListTag)tagCompound.m_128423_("effects");
        if (effects == null || effects.isEmpty()) {
            Tools.error(player, "There are no effects in this wand!");
            return;
        }
        CompoundTag effecttag = effects.m_128728_(this.getMode(wand));
        MobEffectInstance effect = MobEffectInstance.m_19560_((CompoundTag)effecttag);
        entity.m_7292_(effect);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.m_20193_().f_46443_) {
            if (entity instanceof LivingEntity) {
                LivingEntity entityLivingBase = (LivingEntity)entity;
                if (!((Boolean)WandsConfiguration.potionAllowHostile.get()).booleanValue() && entityLivingBase instanceof Enemy) {
                    Tools.error(player, "It is not possible to add effects to hostile mobs with this wand!");
                    return true;
                }
                if (!((Boolean)WandsConfiguration.potionAllowPassive.get()).booleanValue() && !(entityLivingBase instanceof Enemy)) {
                    Tools.error(player, "It is not possible to add effects to passive mobs with this wand!");
                    return true;
                }
                float difficultyScale = (float)((double)entityLivingBase.m_21233_() * (Double)WandsConfiguration.potionDifficultyMult.get() + (Double)WandsConfiguration.potionDifficultyAdd.get());
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                this.addeffect(entityLivingBase, stack, player);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }
}

