/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.varia;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;

public class Tools {
    public static void error(Player player, String msg) {
        player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + msg)), false);
    }

    public static void notify(Player player, MutableComponent msg) {
        player.m_5661_((Component)msg.m_130940_(ChatFormatting.GREEN), false);
    }

    @Nullable
    public static BlockState placeStackAt(Player player, ItemStack blockStack, Level world, BlockPos pos, @Nullable BlockState origState) {
        ItemStack old = player.m_21120_(InteractionHand.MAIN_HAND);
        player.m_21008_(InteractionHand.MAIN_HAND, blockStack);
        BlockHitResult trace = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.UP, pos, false);
        BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, trace));
        Item item = blockStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            if (origState == null && (origState = itemBlock.m_40614_().m_5573_(context)) == null) {
                return null;
            }
            if (itemBlock.m_40576_(context).m_19077_()) {
                // empty if block
            }
            player.m_21008_(InteractionHand.MAIN_HAND, old);
            return origState;
        }
        player.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5);
        blockStack.m_41720_().m_6225_((UseOnContext)context);
        player.m_21008_(InteractionHand.MAIN_HAND, old);
        return world.m_8055_(pos);
    }

    @Nonnull
    public static ItemStack consumeInventoryItem(ItemStack item, Inventory inv, Player player) {
        if (player.m_7500_()) {
            return item;
        }
        int i = Tools.finditem(item, inv);
        if (i < 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = inv.m_8020_(i);
        ItemStack result = stackInSlot.m_41777_();
        result.m_41764_(1);
        int amount = -1;
        stackInSlot.m_41769_(amount);
        if (stackInSlot.m_41613_() == 0) {
            inv.m_6836_(i, ItemStack.f_41583_);
        }
        return result;
    }

    public static void giveItem(Player player, Block block, int cnt) {
        Tools.giveItem(player, new ItemStack((ItemLike)block, cnt));
    }

    public static void giveItem(Player player, ItemStack stack) {
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
    }

    public static int finditem(ItemStack item, Inventory inv) {
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public static Component getBlockName(Block block) {
        ItemStack s = new ItemStack((ItemLike)block, 1);
        if (s.m_41720_() == null) {
            return ComponentFactory.literal((String)"<null>");
        }
        return s.m_41786_();
    }

    public static int getPlayerXP(Player player) {
        return (int)((float)Tools.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static boolean addPlayerXP(Player player, int amount) {
        int experience = Tools.getPlayerXP(player) + amount;
        if (experience < 0) {
            return false;
        }
        player.f_36079_ = experience;
        player.f_36078_ = Tools.getLevelForExperience(experience);
        int expForLevel = Tools.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
        return true;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = Tools.getLevelForExperience(level);
        int nextXP = Tools.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (Tools.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }
}

