/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.FairyFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.FairyFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class FairyFamiliarRenderer
extends MobRenderer<FairyFamiliarEntity, FairyFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/fairy_familiar.png");

    public FairyFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new FairyFamiliarModel(context.m_174023_(OccultismModelLayers.FAMILIAR_FAIRY)), 0.3f);
        this.m_115326_(new SleepLayer((RenderLayerParent<FairyFamiliarEntity, FairyFamiliarModel>)this));
    }

    public void render(FairyFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, (double)pEntity.getAnimationHeight(pPartialTicks), 0.0);
        this.performMagicTransform(pEntity, pEntityYaw, pPartialTicks, pMatrixStack);
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }

    private void performMagicTransform(FairyFamiliarEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn) {
        Entity target = entityIn.getMagicTarget();
        if (target != null) {
            Vec3 pos = entityIn.getMagicPosition(partialTicks).m_82546_(entityIn.m_20318_(partialTicks));
            Vec2 radiusAngle = entityIn.getMagicRadiusAngle(partialTicks);
            matrixStackIn.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            matrixStackIn.m_85845_(new Quaternion(0.0f, -radiusAngle.f_82471_, 0.0f, false));
            this.f_114478_ = 0.0f;
        } else {
            this.f_114478_ = 1.0f;
        }
    }

    public ResourceLocation getTextureLocation(FairyFamiliarEntity entity) {
        return TEXTURES;
    }

    private static class SleepLayer
    extends RenderLayer<FairyFamiliarEntity, FairyFamiliarModel> {
        private static final ResourceLocation SLEEP = new ResourceLocation("occultism", "textures/entity/fairy_familiar_sleep.png");

        public SleepLayer(RenderLayerParent<FairyFamiliarEntity, FairyFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, FairyFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.m_20145_() || !pLivingEntity.isSitting() || pLivingEntity.isPartying()) {
                return;
            }
            FairyFamiliarModel model = (FairyFamiliarModel)this.m_117386_();
            VertexConsumer ivertexbuilder = pBuffer.m_6299_(RenderType.m_110452_((ResourceLocation)SLEEP));
            model.m_7695_(pMatrixStack, ivertexbuilder, pPackedLight, LivingEntityRenderer.m_115338_((LivingEntity)pLivingEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

