/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.upgrademanager;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.inventory.ChargingStationUpgradeManagerMenu;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class AbstractUpgradeManagerScreen
extends AbstractPneumaticCraftContainerScreen<ChargingStationUpgradeManagerMenu, ChargingStationBlockEntity> {
    private static final long TIER_CYCLE_TIME = 20L;
    protected final ItemStack itemStack;
    private Button guiBackButton;
    private final Map<PNCUpgrade, IGuiAnimatedStat> cycleTabs = new Object2ObjectOpenHashMap();

    AbstractUpgradeManagerScreen(ChargingStationUpgradeManagerMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.itemStack = ((ChargingStationBlockEntity)this.te).getPrimaryInventory().getStackInSlot(0);
        this.f_97727_ = 182;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_CHARGING_UPGRADE_MANAGER;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        this.guiBackButton = new WidgetButtonExtended(xStart + 8, yStart + 5, 16, 16, "\u25c0").withTag("close_upgrades");
        this.m_142416_((GuiEventListener)this.guiBackButton);
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        int upgrades = UpgradableItemUtils.getUpgradeCount(this.itemStack, (PNCUpgrade)ModUpgrades.VOLUME.get());
        int volume = this.itemStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(IAirHandler::getVolume).orElse(this.getDefaultVolume());
        float curPressure = ((ChargingStationBlockEntity)this.te).chargingItemPressure;
        this.addPressureInfo(pressureStatText, curPressure, volume, this.getDefaultVolume(), upgrades);
    }

    @Override
    protected void addExtraVolumeModifierInfo(List<Component> text) {
        ItemRegistry.getInstance().addVolumeModifierInfo(this.itemStack, text);
    }

    @Override
    protected boolean shouldAddRedstoneTab() {
        return false;
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    protected abstract int getDefaultVolume();

    @Override
    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        this.f_96547_.m_92877_(matrixStack, this.itemStack.m_41786_().m_7532_(), (float)(this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.itemStack.m_41786_())) / 2.0f, 5.0f, 0x404040);
        int gaugeX = this.f_97726_ * 3 / 4 + 10;
        int gaugeY = this.f_97727_ / 4 + 10;
        this.itemStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> PressureGaugeRenderer2D.drawPressureGauge(matrixStack, this.f_96547_, 0.0f, h.maxPressure(), h.maxPressure(), 0.0f, ((ChargingStationBlockEntity)this.te).chargingItemPressure, gaugeX, gaugeY));
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        RenderSystem.m_157182_();
        Minecraft.m_91087_().m_91291_().m_115123_(this.itemStack, 3, 22);
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    @Override
    protected PointXY getGaugeLocation() {
        return null;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.guiBackButton.m_5691_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        long gameTime = ClientUtils.getClientLevel().m_46467_();
        if (gameTime % 20L == 0L) {
            this.cycleTabs.forEach((upgrade, tab) -> {
                long tier = gameTime % (20L * (long)upgrade.getMaxTier()) / 20L;
                ItemStack stack = new ItemStack((ItemLike)upgrade.getItem((int)tier + 1));
                tab.setTitle(stack.m_41786_());
                tab.setTexture(stack);
            });
        }
    }

    void addUpgradeTabs(Item item, String ... what) {
        boolean leftSided = true;
        for (Map.Entry entry : ModUpgrades.UPGRADES.get().getEntries()) {
            int max;
            PNCUpgrade upgrade = (PNCUpgrade)entry.getValue();
            if (!upgrade.isDependencyLoaded() || (max = ApplicableUpgradesDB.getInstance().getMaxUpgrades(item, upgrade)) <= 0) continue;
            ItemStack upgradeStack = upgrade.getItemStack();
            ArrayList<Component> text = new ArrayList<Component>();
            text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.upgrades.max", max).m_130940_(ChatFormatting.GRAY));
            for (String w : what) {
                String name = PneumaticCraftUtils.modDefaultedString(((ResourceKey)entry.getKey()).m_135782_()).replace(':', '.');
                String key = "pneumaticcraft.gui.tab.info.item." + w + "." + name + "Upgrade";
                if (!I18n.m_118936_((String)key)) continue;
                text.addAll(GuiUtils.xlateAndSplit(key, new Object[0]));
                break;
            }
            IGuiAnimatedStat stat = this.addAnimatedStat(upgradeStack.m_41786_(), upgradeStack, -14920792, leftSided).setText(text);
            stat.setForegroundColor(-16777216);
            if (upgrade.getMaxTier() > 1) {
                this.cycleTabs.put(upgrade, stat);
            }
            leftSided = !leftSided;
        }
    }
}

