/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.gui.AphorismTileScreen;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.AphorismTileBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class AphorismTileBlock
extends AbstractPneumaticCraftBlock
implements ColorHandlers.ITintableBlock,
PneumaticCraftEntityBlock {
    public static final float APHORISM_TILE_THICKNESS = 0.0625f;
    public static final BooleanProperty INVISIBLE = BooleanProperty.m_61465_((String)"invisible");
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public AphorismTileBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 4.0f).m_60910_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)INVISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{INVISIBLE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        if (state.m_60734_() == ModBlocks.APHORISM_TILE.get() && ((Boolean)state.m_61143_((Property)INVISIBLE)).booleanValue()) {
            return selectionContext.m_6226_() ? SHAPES[this.getRotation(state).m_122411_()] : Shapes.m_83040_();
        }
        return SHAPES[this.getRotation(state).m_122411_()];
    }

    @Override
    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.directionProperty(), (Comparable)ctx.m_43719_().m_122424_());
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return state.m_60734_() == ModBlocks.APHORISM_TILE.get() && (Boolean)state.m_61143_((Property)INVISIBLE) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    @Override
    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> curInfo, TooltipFlag flag) {
        CompoundTag subTag;
        super.m_5871_(stack, world, curInfo, flag);
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_("ExtraData") && ((subTag = tag.m_128469_("ExtraData")).m_128441_("borderColor") || subTag.m_128441_("backgroundColor"))) {
            ListTag l = subTag.m_128437_("lines", 8);
            if (!l.isEmpty()) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("gui.tooltip.block.pneumaticcraft.aphorism_tile.text", new Object[0]).m_130940_(ChatFormatting.YELLOW));
                l.forEach(el -> curInfo.add((Component)Component.m_237113_((String)("  " + el.m_7916_())).m_130940_(ChatFormatting.ITALIC)));
            }
            curInfo.add((Component)PneumaticCraftUtils.xlate("gui.tooltip.block.pneumaticcraft.aphorism_tile.reset", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entityLiving, ItemStack iStack) {
        super.m_6402_(world, pos, state, entityLiving, iStack);
        if (world.f_46443_) {
            PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AphorismTileBlockEntity.class).ifPresent(teAT -> {
                CompoundTag tag = iStack.m_41737_("BlockEntityTag");
                if (tag != null) {
                    teAT.readFromPacket(tag);
                }
                AphorismTileScreen.openGui(teAT, true);
                if (entityLiving instanceof Player) {
                    this.sendEditorMessage((Player)entityLiving);
                }
            });
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof AphorismTileBlockEntity)) {
            return InteractionResult.FAIL;
        }
        AphorismTileBlockEntity teAT = (AphorismTileBlockEntity)te;
        if (!world.f_46443_ && player.m_21120_(hand).m_204117_(Tags.Items.DYES) && !teAT.isInvisible()) {
            return this.tryDyeTile(state, player, hand, brtr, teAT);
        }
        if (world.f_46443_ && hand == InteractionHand.MAIN_HAND && player.m_21120_(hand).m_41619_()) {
            return this.openEditorGui(player, teAT);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tryDyeTile(BlockState state, Player player, InteractionHand hand, BlockHitResult brtr, AphorismTileBlockEntity teAT) {
        DyeColor color = DyeColor.getColor((ItemStack)player.m_21120_(hand));
        if (color != null) {
            if (this.clickedBorder(state, brtr.m_82450_())) {
                if (teAT.getBorderColor() != color.m_41060_()) {
                    teAT.setBorderColor(color.m_41060_());
                    if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                }
            } else if (teAT.getBackgroundColor() != color.m_41060_()) {
                teAT.setBackgroundColor(color.m_41060_());
                if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue()) {
                    player.m_21120_(hand).m_41774_(1);
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult openEditorGui(Player player, AphorismTileBlockEntity teAT) {
        AphorismTileScreen.openGui(teAT, false);
        this.sendEditorMessage(player);
        return InteractionResult.SUCCESS;
    }

    private boolean clickedBorder(BlockState state, Vec3 hitVec) {
        double x = Math.abs(hitVec.f_82479_ - (double)((int)hitVec.f_82479_));
        double y = Math.abs(hitVec.f_82480_ - (double)((int)hitVec.f_82480_));
        double z = Math.abs(hitVec.f_82481_ - (double)((int)hitVec.f_82481_));
        return switch (this.getRotation(state)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST, Direction.WEST -> {
                if (y < 0.1 || y > 0.9 || z < 0.1 || z > 0.9) {
                    yield true;
                }
                yield false;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                if (y < 0.1 || y > 0.9 || x < 0.1 || x > 0.9) {
                    yield true;
                }
                yield false;
            }
            case Direction.UP, Direction.DOWN -> x < 0.1 || x > 0.9 || z < 0.1 || z > 0.9;
        };
    }

    private void sendEditorMessage(Player player) {
        MutableComponent msg = Component.m_237113_((String)ChatFormatting.WHITE.toString()).m_7220_((Component)Component.m_237115_((String)"pneumaticcraft.gui.aphorismTileEditor")).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)"pneumaticcraft.gui.holdF1forHelp"));
        player.m_5661_((Component)msg, true);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction face, InteractionHand hand) {
        if (player != null && player.m_6144_()) {
            return PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AphorismTileBlockEntity.class).map(teAt -> {
                if (++teAt.textRotation > 3) {
                    teAt.textRotation = 0;
                }
                teAt.sendDescriptionPacket();
                return true;
            }).orElse(false);
        }
        return super.onWrenched(world, player, pos, face, hand);
    }

    @Override
    protected boolean rotateForgeWay() {
        return false;
    }

    @Override
    public int getTintColor(BlockState state, @javax.annotation.Nullable BlockAndTintGetter world, @javax.annotation.Nullable BlockPos pos, int tintIndex) {
        if (world != null && pos != null) {
            return PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AphorismTileBlockEntity.class).map(teAt -> switch (tintIndex) {
                case 0 -> PneumaticCraftUtils.getDyeColorAsRGB(DyeColor.m_41053_((int)teAt.getBorderColor()));
                case 1 -> ColorHandlers.desaturate(PneumaticCraftUtils.getDyeColorAsRGB(DyeColor.m_41053_((int)teAt.getBackgroundColor())));
                default -> -1;
            }).orElse(-1);
        }
        return -1;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new AphorismTileBlockEntity(pPos, pState);
    }

    public static class ItemBlockAphorismTile
    extends BlockItem
    implements ColorHandlers.ITintableItem {
        public ItemBlockAphorismTile(AphorismTileBlock blockAphorismTile) {
            super((Block)blockAphorismTile, ModItems.defaultProps());
        }

        private static int getColor(ItemStack stack, String key, DyeColor fallback) {
            CompoundTag tag = stack.m_41737_("BlockEntityTag");
            if (tag != null && tag.m_128441_("ExtraData")) {
                return tag.m_128469_("ExtraData").m_128451_(key);
            }
            return fallback.m_41060_();
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            return switch (tintIndex) {
                case 0 -> PneumaticCraftUtils.getDyeColorAsRGB(DyeColor.m_41053_((int)ItemBlockAphorismTile.getColor(stack, "borderColor", DyeColor.BLUE)));
                case 1 -> ColorHandlers.desaturate(PneumaticCraftUtils.getDyeColorAsRGB(DyeColor.m_41053_((int)ItemBlockAphorismTile.getColor(stack, "backgroundColor", DyeColor.WHITE))));
                default -> 0xFFFFFF;
            };
        }
    }
}

