/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.api.block.ITubeNetworkConnector;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ModuleNetworkManager {
    private static final Map<ResourceLocation, ModuleNetworkManager> INSTANCES = new HashMap<ResourceLocation, ModuleNetworkManager>();
    private final Map<AbstractTubeModule, Set<AbstractTubeModule>> connectionCache = new HashMap<AbstractTubeModule, Set<AbstractTubeModule>>();
    private boolean needInvalidate = false;

    public static ModuleNetworkManager getInstance(Level w) {
        return INSTANCES.computeIfAbsent(w.m_46472_().m_135782_(), dimId -> new ModuleNetworkManager());
    }

    Set<AbstractTubeModule> getConnectedModules(AbstractTubeModule module) {
        if (this.needInvalidate) {
            this.connectionCache.clear();
            this.needInvalidate = false;
        }
        return this.connectionCache.computeIfAbsent(module, this::computeConnections);
    }

    public void invalidateCache() {
        this.needInvalidate = true;
    }

    private Set<AbstractTubeModule> computeConnections(AbstractTubeModule module) {
        Level level = module.getTube().nonNullLevel();
        HashSet<AbstractTubeModule> modules = new HashSet<AbstractTubeModule>();
        HashSet<BlockPos> traversedTubes = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> pendingPositions = new ArrayDeque<BlockPos>(List.of(module.getTube().m_58899_()));
        while (!pendingPositions.isEmpty()) {
            BlockPos pos = (BlockPos)pendingPositions.pop();
            PneumaticCraftUtils.getTileEntityAt((BlockGetter)level, pos, PressureTubeBlockEntity.class).ifPresent(tube -> tube.tubeModules().filter(tm -> tm instanceof INetworkedModule && tm.canConnectTo(module)).forEach(modules::add));
            for (Direction dir : DirectionUtil.VALUES) {
                ITubeNetworkConnector nc;
                BlockState state;
                Block block;
                BlockPos pos1 = pos.m_121945_(dir);
                if (!level.m_46749_(pos1) || !((block = (state = level.m_8055_(pos1)).m_60734_()) instanceof ITubeNetworkConnector) || !(nc = (ITubeNetworkConnector)block).canConnectToNetwork(level, pos1, dir.m_122424_(), state) || !traversedTubes.add(pos1)) continue;
                pendingPositions.add(pos1);
            }
        }
        return modules;
    }
}

