/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.forge.datagen.providers;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.client.modulargui.lib.DynamicTextures;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;

public class DynamicTextureProvider
implements DataProvider {
    private final DataGenerator gen;
    private final ExistingFileHelper fileHelper;
    private final String modid;
    private final List<GeneratorResult> results = new ArrayList<GeneratorResult>();

    public DynamicTextureProvider(DataGenerator gen, ExistingFileHelper fileHelper, String modid) {
        this.gen = gen;
        this.fileHelper = fileHelper;
        this.modid = modid;
    }

    public void addTextures() {
    }

    public void addDynamicTextures(DynamicTextures dynamicTextures) {
        dynamicTextures.makeTextures(t -> {
            this.addDynamicTexture(t.dynamicInput(), t.outputLocation(), t.width(), t.height(), t.topBorder(), t.leftBorder(), t.bottomBorder(), t.rightBorder());
            return t.guiTexturePath();
        });
    }

    public void addDynamicTexture(String dynamicInput, String outputTexture, int width, int height, int border) {
        this.addDynamicTexture(dynamicInput, outputTexture, width, height, border, border, border, border);
    }

    public void addDynamicTexture(String dynamicInput, String outputTexture, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        this.addDynamicTexture(new ResourceLocation(this.modid, dynamicInput), new ResourceLocation(this.modid, outputTexture), width, height, topBorder, leftBorder, bottomBorder, rightBorder);
    }

    public void addDynamicTexture(ResourceLocation dynamicInput, ResourceLocation outputTexture, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        try {
            if (!dynamicInput.m_135815_().endsWith(".png")) {
                dynamicInput = new ResourceLocation(dynamicInput.m_135827_(), dynamicInput.m_135815_() + ".png");
            }
            if (!outputTexture.m_135815_().endsWith(".png")) {
                outputTexture = new ResourceLocation(outputTexture.m_135827_(), outputTexture.m_135815_() + ".png");
            }
            Resource inputResource = this.fileHelper.getResource(dynamicInput, PackType.CLIENT_RESOURCES);
            Path mainOutput = this.gen.m_123916_();
            String pathSuffix = "assets/" + outputTexture.m_135827_();
            Path outputFile = mainOutput.resolve(pathSuffix).resolve(outputTexture.m_135815_());
            BufferedImage input = ImageIO.read(inputResource.m_215507_());
            BufferedImage output = new BufferedImage(width, height, 6);
            Graphics2D graphics = output.createGraphics();
            int texWidth = input.getWidth();
            int texHeight = input.getHeight();
            int trimWidth = texWidth - leftBorder - rightBorder;
            int trimHeight = texHeight - topBorder - bottomBorder;
            if (width <= texWidth) {
                trimWidth = Math.min(trimWidth, width - rightBorder);
            }
            if (width <= 0 || height <= 0 || trimWidth <= 0 || trimHeight <= 0) {
                throw new IllegalArgumentException("Invalid size parameters");
            }
            for (int x = 0; x < width; x += trimWidth) {
                int rWidth = Math.min(width - x, trimWidth);
                int trimU = 0;
                if (x != 0) {
                    trimU = x + leftBorder + trimWidth <= width ? leftBorder : texWidth - (width - x);
                }
                this.bufferDynamic(graphics, input, x, 0, trimU, 0, rWidth, topBorder);
                this.bufferDynamic(graphics, input, x, height - bottomBorder, trimU, texHeight - bottomBorder, rWidth, bottomBorder);
                rWidth = Math.min(width - x - leftBorder - rightBorder, trimWidth);
                for (int y = 0; y < height; y += trimHeight) {
                    int rHeight = Math.min(height - y - topBorder - bottomBorder, trimHeight);
                    int trimV = y + (texHeight - topBorder - bottomBorder) <= height ? topBorder : texHeight - (height - y);
                    if (x == 0 && y + topBorder < height - bottomBorder) {
                        this.bufferDynamic(graphics, input, 0, y + topBorder, 0, trimV, leftBorder, rHeight);
                        this.bufferDynamic(graphics, input, width - rightBorder, y + topBorder, trimU + texWidth - rightBorder, trimV, rightBorder, rHeight);
                    }
                    if (y + topBorder >= height - bottomBorder || x + leftBorder >= width - rightBorder) continue;
                    this.bufferDynamic(graphics, input, x + leftBorder, y + topBorder, leftBorder, topBorder, rWidth, rHeight);
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)output, "png", bos);
            this.results.add(new GeneratorResult(bos.toByteArray(), outputFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void bufferDynamic(Graphics2D graphics, BufferedImage image, int x, int y, int textureX, int textureY, int width, int height) {
        graphics.drawImage(image, x, y, x + width, y + height, textureX, textureY, textureX + width, textureY + height, null);
    }

    public void m_213708_(CachedOutput writer) {
        this.addTextures();
        this.results.forEach(result -> DynamicTextureProvider.saveResult(writer, result));
    }

    static void saveResult(CachedOutput arg, GeneratorResult result) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            HashingOutputStream hos = new HashingOutputStream(Hashing.sha1(), (OutputStream)bos);
            hos.write(result.fileBytes);
            arg.m_213871_(result.path, bos.toByteArray(), hos.hash());
            PolyLib.LOGGER.info("Saved file to {}", (Object)result.path);
        }
        catch (IOException ex) {
            PolyLib.LOGGER.error("Failed to save file to {}", (Object)result.path, (Object)ex);
        }
    }

    public String m_6055_() {
        return "dynamic-textures:" + this.modid;
    }

    private static class GeneratorResult {
        private final byte[] fileBytes;
        private final Path path;

        private GeneratorResult(byte[] fileBytes, Path filePath) {
            this.fileBytes = fileBytes;
            this.path = filePath;
        }
    }
}

