/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.mulitblock;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.mulitblock.IMultiblockPart;
import net.creeperhost.polylib.mulitblock.MultiblockControllerBase;
import net.creeperhost.polylib.mulitblock.MultiblockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class MultiblockBlockEntityBase
extends IMultiblockPart {
    private MultiblockControllerBase controller = null;
    private boolean visited = false;
    private boolean saveMultiblockData = false;
    private CompoundTag cachedMultiblockData = null;

    public MultiblockBlockEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    @Override
    public Set<MultiblockControllerBase> attachToNeighbors() {
        IMultiblockPart[] partsToCheck;
        HashSet<MultiblockControllerBase> controllers = null;
        MultiblockControllerBase bestController = null;
        for (IMultiblockPart neighborPart : partsToCheck = this.getNeighboringParts()) {
            MultiblockControllerBase candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblockController()).getClass().equals(this.getMultiblockControllerType())) continue;
            if (controllers == null) {
                controllers = new HashSet<MultiblockControllerBase>();
                bestController = candidate;
            } else if (!controllers.contains(candidate) && candidate.shouldConsume(bestController)) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            this.controller = bestController;
            bestController.attachBlock(this);
        }
        return controllers;
    }

    @Override
    public void assertDetached() {
        if (this.controller != null) {
            PolyLib.LOGGER.info(String.format("[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_()));
            this.controller = null;
        }
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (!compoundTag.m_128469_("multiblockData").m_128456_()) {
            this.cachedMultiblockData = compoundTag.m_128469_("multiblockData");
        }
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            CompoundTag multiblockData = new CompoundTag();
            this.controller.writeToNBT(multiblockData);
            compoundTag.m_128365_("multiblockData", (Tag)multiblockData);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.detachSelf(false);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        MultiblockRegistry.onPartAdded(this.m_58904_(), this);
    }

    protected void encodeDescriptionPacket(CompoundTag packetData) {
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            CompoundTag tag = new CompoundTag();
            this.getMultiblockController().formatDescriptionPacket(tag);
            packetData.m_128365_("multiblockData", (Tag)tag);
        }
    }

    protected void decodeDescriptionPacket(CompoundTag packetData) {
        if (packetData.m_128423_("multiblockData") != null) {
            CompoundTag tag = packetData.m_128469_("multiblockData");
            if (this.isConnected()) {
                this.getMultiblockController().decodeDescriptionPacket(tag);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public CompoundTag getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(MultiblockControllerBase var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public boolean isConnected() {
        return this.controller != null;
    }

    @Override
    public MultiblockControllerBase getMultiblockController() {
        return this.controller;
    }

    @Override
    public BlockPos getWorldLocation() {
        return this.m_58899_();
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public void setUnvisited() {
        this.visited = false;
    }

    @Override
    public void setVisited() {
        this.visited = true;
    }

    @Override
    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void onAssimilated(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public void onDetached(MultiblockControllerBase oldController) {
        this.controller = null;
    }

    @Override
    public abstract MultiblockControllerBase createNewMultiblock();

    @Override
    public IMultiblockPart[] getNeighboringParts() {
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        BlockPos partPosition = this.getWorldLocation();
        for (Direction facing : Direction.values()) {
            BlockPos neighborPosition = partPosition.m_121945_(facing);
            BlockEntity te = this.f_58857_.m_7702_(neighborPosition);
            if (!(te instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        return neighborParts.toArray(new IMultiblockPart[neighborParts.size()]);
    }

    @Override
    public void onOrphaned(MultiblockControllerBase controller, int oldSize, int newSize) {
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(this, chunkUnloading);
            this.controller = null;
        }
        MultiblockRegistry.onPartRemovedFromWorld(this.m_58904_(), this);
    }
}

