/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.handler.attributes;

import cy.jdkdigital.productivebees.handler.attributes.IBeeAttributes;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class BeeAttributesHandler
implements IBeeAttributes {
    protected Map<BeeAttribute<?>, Object> beeAttributes = new HashMap();

    @Override
    public void setDefaults() {
        this.beeAttributes.put(BeeAttributes.PRODUCTIVITY, 1);
        this.beeAttributes.put(BeeAttributes.TEMPER, 1);
        this.beeAttributes.put(BeeAttributes.ENDURANCE, 1);
        this.beeAttributes.put(BeeAttributes.BEHAVIOR, 0);
        this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, 0);
        this.beeAttributes.put(BeeAttributes.TYPE, "hive");
    }

    @Override
    public <T> T getAttributeValue(BeeAttribute<T> attribute) {
        return (T)this.beeAttributes.get(attribute);
    }

    @Override
    public void setAttributeValue(BeeAttribute<?> attribute, int value) {
        this.beeAttributes.put(attribute, value);
    }

    @Override
    public void setAttributeValue(BeeAttribute<?> attribute, String value) {
        this.beeAttributes.put(attribute, value);
    }

    @Override
    public Map<BeeAttribute<?>, Object> getAttributes() {
        return this.beeAttributes;
    }

    @Override
    @Nonnull
    public Tag getAsNBT() {
        for (Map.Entry<BeeAttribute<?>, Object> entry : this.getAttributes().entrySet()) {
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("bee_productivity", this.getAttributeValue(BeeAttributes.PRODUCTIVITY).intValue());
        tag.m_128405_("bee_endurance", this.getAttributeValue(BeeAttributes.ENDURANCE).intValue());
        tag.m_128405_("bee_temper", this.getAttributeValue(BeeAttributes.TEMPER).intValue());
        tag.m_128405_("bee_behavior", this.getAttributeValue(BeeAttributes.BEHAVIOR).intValue());
        tag.m_128405_("bee_weather_tolerance", this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE).intValue());
        tag.m_128359_("bee_type", this.getAttributeValue(BeeAttributes.TYPE));
        return tag;
    }

    @Override
    public void readFromNBT(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.beeAttributes.put(BeeAttributes.PRODUCTIVITY, nbt.m_128451_("bee_productivity"));
            this.beeAttributes.put(BeeAttributes.ENDURANCE, nbt.m_128441_("bee_endurance"));
            this.beeAttributes.put(BeeAttributes.TEMPER, nbt.m_128451_("bee_temper"));
            this.beeAttributes.put(BeeAttributes.BEHAVIOR, nbt.m_128451_("bee_behavior"));
            this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, nbt.m_128451_("bee_weather_tolerance"));
            this.beeAttributes.put(BeeAttributes.TYPE, nbt.m_128461_("bee_type"));
            for (Map.Entry<BeeAttribute<?>, Object> entry : this.getAttributes().entrySet()) {
            }
        }
    }
}

