/*
 * Decompiled with CFR 0.152.
 */
package tfar.quickstack.networking;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;
import tfar.quickstack.client.RendererCubeTarget;

public class PacketBufferExt
extends FriendlyByteBuf {
    public PacketBufferExt(FriendlyByteBuf buf) {
        super((ByteBuf)buf);
    }

    public <T extends BlockEntityType<?>> void writeRegistryIdArray(@Nonnull List<T> entries) {
        this.writeInt(entries.size());
        entries.forEach(i -> this.writeRegistryId(ForgeRegistries.BLOCK_ENTITY_TYPES, i));
    }

    public <T extends BlockEntityType<?>> List<T> readRegistryIdArray() {
        int size = this.readInt();
        return IntStream.range(0, size).mapToObj(value -> (BlockEntityType)this.readRegistryId()).collect(Collectors.toList());
    }

    public void writeRendererCubeTargets(List<RendererCubeTarget> rendererCubeTargets) {
        this.writeInt(rendererCubeTargets.size());
        rendererCubeTargets.forEach(this::writeRendererCubeTarget);
    }

    public List<RendererCubeTarget> readRendererCubeTargets() {
        int targetsLen = this.readInt();
        return IntStream.range(0, targetsLen).mapToObj(i -> this.readRendererCubeTarget()).collect(Collectors.toList());
    }

    private void writeRendererCubeTarget(RendererCubeTarget rendererCubeTarget) {
        this.writeLong(rendererCubeTarget.getBlockPos().m_121878_());
        this.writeInt(rendererCubeTarget.getColor());
    }

    private RendererCubeTarget readRendererCubeTarget() {
        BlockPos blockPos = BlockPos.m_122022_((long)this.readLong());
        int color = this.readInt();
        return new RendererCubeTarget(blockPos, color);
    }
}

