/*
 * Decompiled with CFR 0.152.
 */
package tfar.quickstack.networking;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import tfar.quickstack.client.RendererCubeTarget;
import tfar.quickstack.networking.PacketBufferExt;
import tfar.quickstack.task.ReportTask;

public class S2CReportPacket {
    private int itemsCounter;
    private int affectedContainers;
    private int totalContainers;
    private List<RendererCubeTarget> rendererCubeTargets = new ArrayList<RendererCubeTarget>();

    public S2CReportPacket() {
    }

    public S2CReportPacket(FriendlyByteBuf buf) {
        this.itemsCounter = buf.readInt();
        this.affectedContainers = buf.readInt();
        this.totalContainers = buf.readInt();
        PacketBufferExt packetBufferExt = new PacketBufferExt(buf);
        this.rendererCubeTargets = packetBufferExt.readRendererCubeTargets();
    }

    S2CReportPacket(int itemsCounter, int affectedContainers, int totalContainers, List<RendererCubeTarget> rendererCubeTargets) {
        this.itemsCounter = itemsCounter;
        this.affectedContainers = affectedContainers;
        this.totalContainers = totalContainers;
        this.rendererCubeTargets = rendererCubeTargets;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.itemsCounter);
        buf.writeInt(this.affectedContainers);
        buf.writeInt(this.totalContainers);
        PacketBufferExt packetBufferExt = new PacketBufferExt(buf);
        packetBufferExt.writeRendererCubeTargets(this.rendererCubeTargets);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ReportTask reportTask = new ReportTask(this.itemsCounter, this.affectedContainers, this.totalContainers, this.rendererCubeTargets);
        reportTask.run();
        ctx.get().setPacketHandled(true);
    }
}

