/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.entity;

import cofh.core.util.helpers.ArcheryHelper;
import cofh.lib.util.Utils;
import cofh.redstonearsenal.RedstoneArsenal;
import cofh.redstonearsenal.init.RSAEntities;
import cofh.redstonearsenal.item.FluxWrenchItem;
import cofh.redstonearsenal.item.IFluxItem;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class ThrownFluxWrench
extends Projectile
implements IEntityAdditionalSpawnData {
    protected static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(ThrownFluxWrench.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public float speed = 1.5f;
    public float range = 16.0f;
    public boolean hitSomething = false;

    public ThrownFluxWrench(EntityType<? extends Projectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public ThrownFluxWrench(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends Projectile>)((EntityType)RSAEntities.FLUX_WRENCH.get()), worldIn);
        this.m_6034_(x, y, z);
    }

    public ThrownFluxWrench(Level worldIn, LivingEntity livingEntityIn, ItemStack stackIn) {
        this(worldIn, livingEntityIn.m_20185_(), livingEntityIn.m_20188_() - (double)0.1f, livingEntityIn.m_20189_());
        this.m_5602_((Entity)livingEntityIn);
        this.setItem(stackIn);
        this.m_37251_((Entity)livingEntityIn, livingEntityIn.f_19858_, livingEntityIn.f_19857_, 0.0f, this.speed, 0.5f);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)new ItemStack((ItemLike)this.getDefaultItem()));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item getDefaultItem() {
        return ((Item)RedstoneArsenal.ITEMS.get("flux_wrench")).m_5456_();
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack getItem() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    public void setItem(ItemStack stack) {
        if (stack.m_41720_() != this.getDefaultItem() || stack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)((ItemStack)Util.m_137469_((Object)stack.m_41777_(), itemStack -> itemStack.m_41764_(1))));
        }
    }

    public boolean isEmpowered() {
        ItemStack stack = this.getItem();
        return ((FluxWrenchItem)stack.m_41720_()).isEmpowered(stack);
    }

    public void m_8119_() {
        super.m_8119_();
        this.calculateCollision(this.f_19853_);
        this.m_20101_();
        if (!this.m_6084_()) {
            return;
        }
        Vec3 velocity = this.m_20184_();
        Entity owner = this.m_37282_();
        if (owner != null) {
            Vec3 relPos = owner.m_20299_(0.0f).m_82546_(this.m_20182_());
            double distance = relPos.m_82553_();
            if (distance > (double)this.range) {
                FluxWrenchItem wrench;
                Item item;
                ItemStack stack = this.getItem();
                if (this.isEmpowered() && (item = stack.m_41720_()) instanceof FluxWrenchItem && (wrench = (FluxWrenchItem)item).useEnergy(stack, true, owner)) {
                    this.teleportEffects(owner);
                    this.returnToInventory(owner);
                    return;
                }
                this.hitSomething = true;
            }
            if (this.hitSomething) {
                if (distance < 1.5) {
                    this.returnToInventory(owner);
                } else {
                    this.m_20256_(relPos.m_82490_((double)this.speed / distance));
                }
            }
        }
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + velocity.f_82479_ * 0.75, this.m_20186_() + velocity.f_82480_ * 0.75, this.m_20189_() + velocity.f_82481_ * 0.75, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            }
        }
        this.m_6034_(this.m_20185_() + velocity.f_82479_, this.m_20186_() + velocity.f_82480_, this.m_20189_() + velocity.f_82481_);
    }

    public void calculateCollision(Level world) {
        Vec3 start = this.m_20182_();
        Vec3 end = start.m_82549_(this.m_20184_());
        BlockHitResult blockResult = this.getBlockHitResult(world, start, end);
        boolean blockCollision = false;
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            end = blockResult.m_82450_();
            BlockPos blockpos = blockResult.m_82425_();
            BlockState blockstate = world.m_8055_(blockpos);
            if (blockstate.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(blockpos);
            } else if (blockstate.m_60713_(Blocks.f_50446_)) {
                BlockEntity blockentity = this.f_19853_.m_7702_(blockpos);
                if (blockentity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                    TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockentity));
                }
            } else {
                blockCollision = true;
            }
        }
        this.hitEntities(this.f_19853_, start, end);
        if (blockCollision && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)blockResult)) {
            this.m_8060_(blockResult);
        }
    }

    public BlockHitResult getBlockHitResult(Level world, Vec3 startPos, Vec3 endPos) {
        return world.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    public void hitEntities(Level world, Vec3 startPos, Vec3 endPos) {
        ArcheryHelper.findHitEntities((Level)world, (Projectile)this, (Vec3)startPos, (Vec3)endPos, x$0 -> this.m_5603_((Entity)x$0)).filter(result -> !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)result)).forEach(this::m_5790_);
    }

    protected void m_6532_(HitResult result) {
        if (!this.hitSomething) {
            Entity owner = this.m_37282_();
            if (owner != null) {
                FluxWrenchItem wrench;
                Item item;
                Vec3 pos = this.m_20182_();
                ItemStack stack = this.getItem();
                if (this.isEmpowered() && (item = stack.m_41720_()) instanceof FluxWrenchItem && (wrench = (FluxWrenchItem)item).useEnergy(stack, true, owner)) {
                    this.teleportEffects(owner);
                    this.returnToInventory(owner);
                } else {
                    Vec3 relPos = owner.m_20299_(1.0f).m_82546_(pos);
                    double distance = relPos.m_82553_();
                    if (distance < 1.5) {
                        this.returnToInventory(owner);
                    } else {
                        this.m_20256_(relPos.m_82490_((double)this.speed * 0.5 / distance));
                    }
                }
            } else {
                this.m_20256_(this.m_20184_().m_82490_(-0.5));
            }
            this.hitSomething = true;
        }
    }

    protected void returnToInventory(Entity owner) {
        block3: {
            block2: {
                if (!(owner instanceof Player)) break block2;
                Player player = (Player)owner;
                if (player.f_36093_.m_36054_(this.getItem())) break block3;
            }
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), this.getItem()));
        }
        this.m_146870_();
    }

    protected void teleportEffects(Entity owner) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        Vec3 pos = this.m_20182_();
        AABB bounds = this.m_20191_();
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 10, bounds.m_82362_() * 0.4, bounds.m_82376_() * 0.5, bounds.m_82385_() * 0.4, 0.0);
        pos = owner.m_20182_();
        this.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11757_, SoundSource.BLOCKS, 0.5f, (1.0f + (this.f_19853_.f_46441_.m_188501_() - this.f_19853_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void m_7822_(byte event) {
        if (event == 3) {
            Vec3 pos = this.m_20182_();
            this.f_19853_.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            Entity owner = this.m_37282_();
            if (owner == null) return;
        }
        super.m_7822_(event);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity owner;
        if (!this.m_6084_() || this.f_19853_.m_5776_()) {
            return;
        }
        Entity target = result.m_82443_();
        if (target.equals((Object)(owner = this.m_37282_()))) {
            this.returnToInventory(owner);
        } else if (target.m_6469_(IFluxItem.fluxRangedDamage(this, owner), this.calculateDamage(target)) && target.m_6095_() != EntityType.f_20566_) {
            int fireAspect = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44981_, (ItemStack)this.getItem());
            if (this.m_6060_() || fireAspect > 0) {
                target.m_20254_(Math.max(this.m_6060_() ? 5 : 0, fireAspect * 4));
            }
        }
        this.m_6532_((HitResult)result);
    }

    protected float calculateDamage(Entity target) {
        ItemStack stack = this.getItem();
        Entity owner = this.m_37282_();
        float damage = ((FluxWrenchItem)stack.m_41720_()).getRangedAttackDamage(stack);
        if (target instanceof LivingEntity) {
            damage += EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)((LivingEntity)target).m_6336_());
            if (owner instanceof LivingEntity) {
                stack.m_41720_().m_7579_(stack, (LivingEntity)target, (LivingEntity)owner);
            }
        } else {
            damage += EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
        }
        return damage;
    }

    protected void m_8060_(BlockHitResult result) {
        Item item;
        if (!this.m_6084_() || this.f_19853_.m_5776_()) {
            return;
        }
        BlockState state = this.f_19853_.m_8055_(result.m_82425_());
        state.m_60669_(this.f_19853_, state, result, (Projectile)this);
        Entity owner = this.m_37282_();
        ItemStack stack = this.getItem();
        if (owner instanceof Player && (item = stack.m_41720_()) instanceof FluxWrenchItem) {
            FluxWrenchItem wrench = (FluxWrenchItem)item;
            wrench.useRanged(this.f_19853_, stack, (Player)owner, result);
        }
        this.m_6532_((HitResult)result);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item"));
        this.setItem(itemstack);
        this.hitSomething = nbt.m_128471_("hit");
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.m_41619_()) {
            nbt.m_128365_("item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
        nbt.m_128379_("hit", this.hitSomething);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Entity owner = this.m_37282_();
        buffer.writeInt(owner == null ? -1 : owner.m_19879_());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int id = additionalData.readInt();
        if (id >= 0) {
            this.m_5602_(this.f_19853_.m_6815_(id));
        }
    }
}

