/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ObjectHolder;
import wile.redstonepen.blocks.CircuitComponents;
import wile.redstonepen.blocks.ControlBox;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.detail.ModRenderers;
import wile.redstonepen.items.RedstonePenItem;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.ExtendedShapelessRecipe;
import wile.redstonepen.libmc.Registries;

public class ModContent {
    public static void init(String modid) {
        detail.MODID = modid;
        ModContent.initBlocks();
        ModContent.initItems();
        Registries.addRecipeSerializer("crafting_extended_shapeless", () -> ExtendedShapelessRecipe.SERIALIZER);
    }

    public static void initBlocks() {
        Registries.addBlock("track", () -> new RedstoneTrack.RedstoneTrackBlock(0L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60988_().m_60977_()), RedstoneTrack.TrackBlockEntity::new);
        Registries.addBlock("relay", () -> new CircuitComponents.RelayBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 16.0)), CircuitComponents.DirectedComponentBlockItem::new);
        Registries.addBlock("inverted_relay", () -> new CircuitComponents.InvertedRelayBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 16.0)), CircuitComponents.DirectedComponentBlockItem::new);
        Registries.addBlock("bistable_relay", () -> new CircuitComponents.BistableRelayBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 16.0)), CircuitComponents.DirectedComponentBlockItem::new);
        Registries.addBlock("pulse_relay", () -> new CircuitComponents.PulseRelayBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 16.0)), CircuitComponents.DirectedComponentBlockItem::new);
        Registries.addBlock("bridge_relay", () -> new CircuitComponents.BridgeRelayBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 16.0)), CircuitComponents.DirectedComponentBlockItem::new);
        Registries.addBlock("control_box", () -> new ControlBox.ControlBoxBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), new AABB[]{Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Auxiliaries.getPixeledAABB(3.0, 1.0, 3.0, 13.0, 3.9, 13.0)}), CircuitComponents.DirectedComponentBlockItem::new, ControlBox.ControlBoxBlockEntity::new, ControlBox.ControlBoxUiContainer::new);
    }

    public static void initItems() {
        Registries.addItem("quill", () -> new RedstonePenItem(new Item.Properties().m_41491_(Registries.getCreativeModeTab()).m_41497_(Rarity.UNCOMMON).m_41487_(1).m_41499_(0)));
        Registries.addItem("pen", () -> new RedstonePenItem(new Item.Properties().m_41491_(Registries.getCreativeModeTab()).m_41497_(Rarity.UNCOMMON).m_41487_(0).m_41499_(256)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerMenuGuis(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(Registries.getMenuTypeOfBlock("control_box"), ControlBox.ControlBoxGui::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processContentClientSide() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerBlockEntityRenderers() {
        BlockEntityRenderers.m_173590_(Registries.getBlockEntityTypeOfBlock("track"), ModRenderers.TrackTer::new);
    }

    public static MenuType<?> getMenuTypeOfBlock(String block_name) {
        return Registries.getMenuTypeOfBlock(block_name);
    }

    public static MenuType<?> getMenuTypeOfBlock(Block block) {
        return Registries.getMenuTypeOfBlock(block);
    }

    public static BlockEntityType<?> getBlockEntityTypeOfBlock(String block_name) {
        return Registries.getBlockEntityTypeOfBlock(block_name);
    }

    public static BlockEntityType<?> getBlockEntityTypeOfBlock(Block block) {
        return Registries.getBlockEntityTypeOfBlock(block);
    }

    private static class detail {
        public static String MODID = "";

        private detail() {
        }
    }

    public static final class references {
        @ObjectHolder(registryName="block", value="redstonepen:track")
        public static final RedstoneTrack.RedstoneTrackBlock TRACK_BLOCK = null;
        @ObjectHolder(registryName="block", value="redstonepen:bridge_relay")
        public static final CircuitComponents.BridgeRelayBlock BRIDGE_RELAY_BLOCK = null;
        @ObjectHolder(registryName="block", value="redstonepen:control_box")
        public static final ControlBox.ControlBoxBlock CONTROLBOX_BLOCK = null;
    }
}

