/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import reliquary.blocks.tile.PassivePedestalBlockEntity;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.WorldHelper;

public class PassivePedestalBlock
extends Block
implements EntityBlock {
    static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)3.5, (double)9.0, (double)4.0, (double)4.0, (double)10.0, (double)12.0), Block.m_49796_((double)12.0, (double)9.0, (double)4.0, (double)12.5, (double)10.0, (double)12.0), Block.m_49796_((double)3.5, (double)9.0, (double)3.5, (double)12.5, (double)10.0, (double)4.0), Block.m_49796_((double)3.5, (double)9.0, (double)12.0, (double)12.5, (double)10.0, (double)12.5), Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public PassivePedestalBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 2.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.isDisabled()) {
            return;
        }
        super.m_49811_(group, items);
    }

    protected boolean isDisabled() {
        return Boolean.TRUE.equals(Settings.COMMON.disable.disablePassivePedestal.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() == null) {
            return this.m_49966_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43723_().m_6350_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (level.f_46443_) {
            return !heldItem.m_41619_() || player.m_6047_() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        if (!(level.m_7702_(pos) instanceof PassivePedestalBlockEntity)) {
            return InteractionResult.FAIL;
        }
        Optional<PassivePedestalBlockEntity> pedestal = WorldHelper.getBlockEntity((BlockGetter)level, pos, PassivePedestalBlockEntity.class);
        if (heldItem.m_41619_()) {
            if (player.m_6047_() && pedestal.isPresent()) {
                pedestal.get().removeAndSpawnItem(level);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return pedestal.map(ped -> InventoryHelper.getItemHandlerFrom(ped).map(itemHandler -> InventoryHelper.tryAddingPlayerCurrentItem(player, itemHandler, InteractionHand.MAIN_HAND) ? InteractionResult.SUCCESS : InteractionResult.CONSUME).orElse(InteractionResult.CONSUME)).orElse(InteractionResult.CONSUME);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        WorldHelper.getBlockEntity((BlockGetter)level, pos, PassivePedestalBlockEntity.class).ifPresent(pedestal -> pedestal.dropPedestalInventory(level));
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PassivePedestalBlockEntity(pos, state);
    }

    public static void onRightClicked(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!(player.m_6047_() && player.m_21205_().m_41619_() && player.m_21206_().m_41619_())) {
            return;
        }
        Block block = player.f_19853_.m_8055_(event.getPos()).m_60734_();
        if (!(block instanceof PassivePedestalBlock)) {
            return;
        }
        PassivePedestalBlockEntity pedestal = (PassivePedestalBlockEntity)player.f_19853_.m_7702_(event.getPos());
        if (pedestal != null) {
            pedestal.removeAndSpawnItem(player.f_19853_);
        }
        event.setCanceled(true);
    }
}

