/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jade.provider;

import java.text.SimpleDateFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import reliquary.blocks.AlkahestryAltarBlock;
import reliquary.blocks.tile.AlkahestryAltarBlockEntity;
import reliquary.compat.jade.provider.JadeHelper;
import reliquary.reference.Settings;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public class DataProviderAltar
implements IBlockComponentProvider,
IServerDataProvider<BlockEntity> {
    private static final ResourceLocation ALTAR_UID = new ResourceLocation("reliquary", "altar");

    @Nullable
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        return super.getIcon(accessor, config, currentIcon);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        BlockEntity blockEntity;
        if (Boolean.TRUE.equals(Settings.CLIENT.wailaShiftForInfo.get()) && !accessor.getPlayer().m_6047_()) {
            tooltip.add((Component)Component.m_237115_((String)"waila.reliquary.shift_for_more").m_130940_(ChatFormatting.ITALIC));
            return;
        }
        if (!(accessor.getBlock() instanceof AlkahestryAltarBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof AlkahestryAltarBlockEntity)) {
            return;
        }
        AlkahestryAltarBlockEntity altar = (AlkahestryAltarBlockEntity)blockEntity;
        IElementHelper helper = tooltip.getElementHelper();
        if (!altar.isActive()) {
            tooltip.add((Component)Component.m_237115_((String)"waila.reliquary.altar.inactive").m_130940_(ChatFormatting.RED));
            Vec2 delta = new Vec2(0.0f, -4.0f);
            IElement redstoneIcon = helper.item(Items.f_42451_.m_7968_(), JadeHelper.ITEM_ICON_SCALE);
            IElement requirementText = helper.text((Component)Component.m_237113_((String)String.format("%d / %d", altar.getRedstoneCount(), Settings.COMMON.blocks.altar.redstoneCost.get())));
            redstoneIcon.size(redstoneIcon.getSize().m_165910_(delta)).translate(delta);
            requirementText.size(requirementText.getSize().m_165910_(delta)).translate(delta.m_165910_(new Vec2(0.0f, (redstoneIcon.getSize().f_82471_ - requirementText.getSize().f_82471_) / 2.0f)));
            tooltip.add(List.of(redstoneIcon, requirementText));
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"waila.reliquary.altar.active").m_130940_(ChatFormatting.GREEN));
        int cycleTime = accessor.getServerData().m_128451_("cycleTime");
        tooltip.add((Component)Component.m_237110_((String)"waila.reliquary.altar.time_remaining", (Object[])new Object[]{new SimpleDateFormat("mm:ss").format(cycleTime * 50)}));
    }

    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity t, boolean showDetails) {
        AlkahestryAltarBlockEntity be = (AlkahestryAltarBlockEntity)t;
        data.m_128405_("cycleTime", be.getCycleTime());
    }

    public ResourceLocation getUid() {
        return ALTAR_UID;
    }
}

