/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items.util.fluid;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import reliquary.init.ModItems;
import reliquary.items.InfernalChaliceItem;
import reliquary.reference.Settings;

public class FluidHandlerInfernalChalice
extends FluidHandlerItemStack {
    private static final String FLUID_STACKS_TAG = "fluidStacks";

    public FluidHandlerInfernalChalice(ItemStack chalice) {
        super(chalice, ((Integer)Settings.COMMON.items.infernalChalice.fluidLimit.get()).intValue());
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return !((InfernalChaliceItem)((Object)ModItems.INFERNAL_CHALICE.get())).isEnabled(this.container) && fluid.getFluid().m_205067_(FluidTags.f_13132_) && this.getFluid().getAmount() >= fluid.getAmount();
    }

    protected void setContainerToEmpty() {
        this.setFluid(new FluidStack((Fluid)Fluids.f_76195_, 0));
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return ((InfernalChaliceItem)((Object)ModItems.INFERNAL_CHALICE.get())).isEnabled(this.container) && fluid.getFluid() == Fluids.f_76195_;
    }

    protected void setFluid(FluidStack fluid) {
        if (!this.container.m_41782_()) {
            this.container.m_41751_(new CompoundTag());
        }
        this.container.m_41783_().m_128405_(FLUID_STACKS_TAG, fluid.getAmount());
    }

    public FluidStack getFluid() {
        CompoundTag tagCompound = this.container.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_(FLUID_STACKS_TAG)) {
            return new FluidStack((Fluid)Fluids.f_76195_, 0);
        }
        return new FluidStack((Fluid)Fluids.f_76195_, tagCompound.m_128451_(FLUID_STACKS_TAG));
    }
}

