/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.maptrades;

import com.telepathicgrunt.repurposedstructures.misc.maptrades.MerchantMapUpdating;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import org.jetbrains.annotations.Nullable;

public class StructureSpecificMaps {

    public static class TreasureMapForEmeralds
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final ResourceKey<Structure> destination;
        private final TagKey<Structure> destinationTag;
        private final String displayName;
        private final MapDecoration.Type destinationType;
        private final int maxUses;
        private final int villagerXp;
        private final int spawnRegionSearchRadius;

        public TreasureMapForEmeralds(int emeraldCost, String csf, String displayName, MapDecoration.Type mapIcon, int maxUse, int xp, int spawnRegionSearchRadius) {
            this.emeraldCost = emeraldCost;
            if (csf.startsWith("#")) {
                this.destination = null;
                this.destinationTag = TagKey.m_203882_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation(csf.replaceFirst("#", "")));
            } else {
                this.destination = ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation(csf));
                this.destinationTag = null;
            }
            this.displayName = displayName;
            this.destinationType = mapIcon;
            this.maxUses = maxUse;
            this.villagerXp = xp;
            this.spawnRegionSearchRadius = spawnRegionSearchRadius;
        }

        private boolean mapValid(ServerLevel level) {
            HolderSet holderSet;
            if (this.destinationTag == null) {
                holderSet = this.getHolderSet(level);
            } else {
                Optional optionalHolders = level.m_5962_().m_175515_(Registry.f_235725_).m_203431_(this.destinationTag);
                if (optionalHolders.isEmpty()) {
                    return false;
                }
                holderSet = (HolderSet)optionalHolders.get();
            }
            boolean isValidSpawning = true;
            for (Holder structureHolder : holderSet) {
                boolean validStructureSet = false;
                for (Holder structureSetHolder : level.m_7726_().m_8481_().m_207969_().collect(Collectors.toUnmodifiableSet())) {
                    for (StructureSet.StructureSelectionEntry structureSelectionEntry : ((StructureSet)structureSetHolder.m_203334_()).f_210003_()) {
                        if (!((Structure)structureSelectionEntry.f_210026_().m_203334_()).equals(structureHolder.m_203334_())) continue;
                        validStructureSet = true;
                        break;
                    }
                    if (!validStructureSet) continue;
                    break;
                }
                if (!validStructureSet) {
                    isValidSpawning = false;
                    break;
                }
                if (!level.m_7726_().m_8481_().m_62218_().m_207840_().stream().noneMatch(e -> ((Structure)structureHolder.m_203334_()).m_226559_().m_203333_(e))) continue;
                isValidSpawning = false;
                break;
            }
            return isValidSpawning;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            Level level = entity.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (!this.mapValid(serverlevel)) {
                    return null;
                }
                return this.getOffer(serverlevel, entity);
            }
            return null;
        }

        private HolderSet<Structure> getHolderSet(ServerLevel level) {
            Registry registry = level.m_5962_().m_175515_(Registry.f_235725_);
            return HolderSet.m_205809_((Holder[])new Holder[]{registry.m_206081_(this.destination)});
        }

        private MerchantOffer getOffer(ServerLevel level, Entity entity) {
            if (this.destinationTag == null) {
                HolderSet<Structure> holderSet = this.getHolderSet(level);
                return MerchantMapUpdating.updateMapAsync(entity, this.emeraldCost, this.displayName, this.destinationType, this.maxUses, this.villagerXp, holderSet, this.spawnRegionSearchRadius);
            }
            return MerchantMapUpdating.updateMapAsync(entity, this.emeraldCost, this.displayName, this.destinationType, this.maxUses, this.villagerXp, this.destinationTag, this.spawnRegionSearchRadius);
        }
    }
}

