/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.yabn.base;

import com.teamresourceful.resourcefullib.common.yabn.base.YabnElement;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.BooleanContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.ByteContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.DoubleContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.FloatContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.IntContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.LongContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.PrimitiveContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.ShortContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.StringContents;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public record YabnPrimitive(PrimitiveContents contents) implements YabnElement
{
    public static YabnPrimitive ofString(String string) {
        return new YabnPrimitive(new StringContents(string));
    }

    public static YabnPrimitive ofBoolean(boolean bool) {
        return new YabnPrimitive(new BooleanContents(bool));
    }

    public static YabnPrimitive ofFloat(float f) {
        return new YabnPrimitive(new FloatContents(f));
    }

    public static YabnPrimitive ofDouble(double d) {
        return new YabnPrimitive(new DoubleContents(d));
    }

    public static YabnPrimitive ofByte(byte b) {
        return new YabnPrimitive(new ByteContents(b));
    }

    public static YabnPrimitive ofShort(short s) {
        return new YabnPrimitive(new ShortContents(s));
    }

    public static YabnPrimitive ofInt(int i) {
        return new YabnPrimitive(new IntContents(i));
    }

    public static YabnPrimitive ofLong(long l) {
        return new YabnPrimitive(new LongContents(l));
    }

    @Override
    public byte[] toData(@Nullable String key) {
        if (key == null) {
            return this.toData();
        }
        byte[] data = this.contents.toData();
        if (data.length == 0) {
            return YabnElement.key(this.contents.getId().id, key);
        }
        return ArrayUtils.addAll((byte[])YabnElement.key(this.contents.getId().id, key), (byte[])data);
    }

    @Override
    public byte[] toData() {
        byte[] data = this.contents.toData();
        if (data.length == 0) {
            return new byte[]{this.contents.getId().id};
        }
        return ArrayUtils.addAll((byte[])new byte[]{this.contents.getId().id}, (byte[])data);
    }
}

