/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.compat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Tools;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RFToolsControlTOPDriver
implements TOPDriver {
    public static final RFToolsControlTOPDriver DRIVER = new RFToolsControlTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        ResourceLocation id = Tools.getId((BlockState)blockState);
        if (!this.drivers.containsKey(id)) {
            if (blockState.m_60734_() == VariousModule.NODE.get()) {
                this.drivers.put(id, new NodeDriver());
            } else if (blockState.m_60734_() == ProcessorModule.PROCESSOR.get()) {
                this.drivers.put(id, new ProcessorDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class NodeDriver
    extends DefaultDriver {
        private NodeDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), node -> {
                probeInfo.text(CompoundText.createLabelInfo((String)"Channel: ", (Object)node.getChannelName()));
                probeInfo.text(CompoundText.createLabelInfo((String)"Name: ", (Object)node.getNodeName()));
            }, (String)"Bad tile entity!");
        }
    }

    private static class ProcessorDriver
    extends DefaultDriver {
        private ProcessorDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), processor -> {
                List<String> lastMessages;
                if (processor.hasNetworkCard()) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Channel: ", (Object)processor.getChannelName()));
                    probeInfo.text(CompoundText.createLabelInfo((String)"Nodes: ", (Object)processor.getNodeCount()));
                }
                if (mode == ProbeMode.EXTENDED && !(lastMessages = processor.getLastMessages(6)).isEmpty()) {
                    IProbeInfo v = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-65536)));
                    for (String s : lastMessages) {
                        v.text(CompoundText.create().text("    " + s));
                    }
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

