/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.vectorart;

import com.mojang.blaze3d.vertex.PoseStack;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpBox;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpLine;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpText;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public abstract class GfxOp {
    public abstract void render(PoseStack var1, MultiBufferSource var2);

    public abstract GfxOpType getType();

    public static GfxOp readFromNBT(CompoundTag tag) {
        GfxOpType type = GfxOpType.values()[tag.m_128445_("type")];
        GfxOp op = GfxOp.createGfxOp(type);
        op.readFromNBTInternal(tag);
        return op;
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("type", (byte)this.getType().ordinal());
        this.writeToNBTInternal(tag);
        return tag;
    }

    protected abstract void readFromNBTInternal(CompoundTag var1);

    protected abstract void writeToNBTInternal(CompoundTag var1);

    public static GfxOp readFromBuf(FriendlyByteBuf buf) {
        GfxOpType type = GfxOpType.values()[buf.readByte()];
        GfxOp op = GfxOp.createGfxOp(type);
        op.readFromBufInternal(buf);
        return op;
    }

    private static GfxOp createGfxOp(GfxOpType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case GfxOpType.OP_BOX -> new GfxOpBox();
            case GfxOpType.OP_LINE -> new GfxOpLine();
            case GfxOpType.OP_TEXT -> new GfxOpText();
        };
    }

    public void writeToBuf(FriendlyByteBuf buf) {
        buf.writeByte(this.getType().ordinal());
        this.writeToBufInternal(buf);
    }

    protected abstract void readFromBufInternal(FriendlyByteBuf var1);

    protected abstract void writeToBufInternal(FriendlyByteBuf var1);
}

