/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lib.varia.ComponentFactory;
import mcjty.rftoolsstorage.modules.modularstorage.items.StorageModuleItem;
import mcjty.rftoolsstorage.storage.StorageEntry;
import mcjty.rftoolsstorage.storage.StorageHolder;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CommandRestore
implements Command<CommandSourceStack> {
    private static final CommandRestore CMD = new CommandRestore();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"restore").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.word()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String uuidString = (String)context.getArgument("uuid", String.class);
        ItemStack stack = ((CommandSourceStack)context.getSource()).m_81375_().m_21205_();
        if (!(stack.m_41720_() instanceof StorageModuleItem)) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)ComponentFactory.literal((String)"Keep a storage module in your main hand!").m_130938_(style -> style.m_131157_(ChatFormatting.RED)), true);
            return 0;
        }
        int maxSize = StorageModuleItem.getSize(stack);
        StorageHolder holder = StorageHolder.get((Level)((CommandSourceStack)context.getSource()).m_81372_());
        StorageEntry foundEntry = null;
        for (StorageEntry storage : holder.getStorages()) {
            if (!storage.getUuid().toString().startsWith(uuidString)) continue;
            if (foundEntry != null) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)ComponentFactory.literal((String)"Multiple storage entries match this UUID part!").m_130938_(style -> style.m_131157_(ChatFormatting.RED)), true);
                return 0;
            }
            foundEntry = storage;
        }
        if (foundEntry != null) {
            if (foundEntry.getStacks().size() != maxSize) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)ComponentFactory.literal((String)("Wrong foundEntry module tier! " + foundEntry.getStacks().size() + " stacks are required!")).m_130938_(style -> style.m_131157_(ChatFormatting.RED)), true);
            } else {
                stack.m_41784_().m_128362_("uuid", foundEntry.getUuid());
                ((CommandSourceStack)context.getSource()).m_81375_().f_36095_.m_38946_();
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)ComponentFactory.literal((String)("No storage found with UUID " + uuidString)).m_130938_(style -> style.m_131157_(ChatFormatting.RED)), true);
        }
        return 0;
    }
}

