/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.refinedstoragerequestify.proxy.block.network;

import com.buuz135.refinedstoragerequestify.proxy.Registry;
import com.buuz135.refinedstoragerequestify.proxy.block.BlockCraftingEmitter;
import com.buuz135.refinedstoragerequestify.proxy.block.tile.TileCraftingEmitter;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeCraftingEmitter
extends NetworkNode
implements IType {
    public static final ResourceLocation ID = new ResourceLocation("rsrequestify", "crafting_emitter");
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilter";
    private BaseItemHandler itemFilter = new BaseItemHandler(9).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private FluidInventory fluidFilter = new FluidInventory(9).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private int type = 0;
    private ICraftingTask craftingTask = null;

    public NetworkNodeCraftingEmitter(Level level, BlockPos pos) {
        super(level, pos);
    }

    public void update() {
        super.update();
        if (this.network == null) {
            return;
        }
        if (this.canUpdate() && this.ticks % 4 == 0 && (this.craftingTask == null || !this.network.getCraftingManager().getTasks().contains(this.craftingTask))) {
            int i;
            if (!(this.craftingTask == null || this.craftingTask.getCompletionPercentage() != 100 && this.network.getCraftingManager().getTasks().contains(this.craftingTask))) {
                this.craftingTask = null;
                this.updateState();
            }
            if (this.type == 0) {
                block0: for (ICraftingTask task : this.network.getCraftingManager().getTasks()) {
                    for (i = 0; i < this.itemFilter.getSlots(); ++i) {
                        if (task.getRequested().getItem() == null || !task.getRequested().getItem().m_41656_(this.itemFilter.getStackInSlot(i))) continue;
                        this.craftingTask = task;
                        this.updateState();
                        continue block0;
                    }
                }
            }
            if (this.type == 1) {
                block2: for (ICraftingTask task : this.network.getCraftingManager().getTasks()) {
                    for (i = 0; i < this.fluidFilter.getSlots(); ++i) {
                        if (task.getRequested().getFluid() == null || !task.getRequested().getFluid().isFluidEqual(this.fluidFilter.getFluid(i))) continue;
                        this.craftingTask = task;
                        this.updateState();
                        continue block2;
                    }
                }
            }
        }
    }

    public ICraftingTask getCraftingTask() {
        return this.craftingTask;
    }

    public int getEnergyUsage() {
        return 10;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public int getType() {
        return this.level.f_46443_ ? (Integer)TileCraftingEmitter.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilter;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilter;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilter, (int)0, (CompoundTag)tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilter.writeToNbt());
        return tag;
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilter, (int)0, (CompoundTag)tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilter.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    private void updateState() {
        this.level.m_46597_(this.pos, (BlockState)((BlockCraftingEmitter)((Object)Registry.CRAFTING_EMITTER.get())).m_49966_().m_61124_((Property)BlockCraftingEmitter.POWERED, (Comparable)Boolean.valueOf(this.craftingTask != null)));
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = this.pos.m_121955_(direction.m_122424_().m_122436_());
            if (ForgeEventFactory.onNeighborNotify((Level)this.level, (BlockPos)this.pos, (BlockState)this.level.m_8055_(this.pos), EnumSet.of(direction.m_122424_()), (boolean)false).isCanceled()) {
                return;
            }
            this.level.m_46586_(blockpos, (Block)Registry.CRAFTING_EMITTER.get(), this.pos);
            this.level.m_46590_(blockpos, (Block)Registry.CRAFTING_EMITTER.get(), direction);
        }
    }
}

