/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.api.prefab;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScanResultProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractScanResultProvider
implements ScanResultProvider {
    protected Player player;
    protected Vec3 center;
    protected float radius;

    @Override
    public void initialize(Player player, Collection<ItemStack> modules, Vec3 center, float radius, int scanTicks) {
        this.player = player;
        this.center = center;
        this.radius = radius;
    }

    @Override
    public void reset() {
        this.player = null;
        this.center = null;
        this.radius = 0.0f;
    }

    protected static void renderIconLabel(MultiBufferSource bufferSource, PoseStack poseStack, float yaw, float pitch, Vec3 lookVec, Vec3 viewerEyes, float displayDistance, Vec3 resultPos, ResourceLocation icon, @Nullable Component label) {
        Vec3 toResult = resultPos.m_82546_(viewerEyes);
        float distance = (float)toResult.m_82553_();
        float lookDirDot = (float)lookVec.m_82526_(toResult.m_82541_());
        float sqLookDirDot = lookDirDot * lookDirDot;
        float sq2LookDirDot = sqLookDirDot * sqLookDirDot;
        float focusScale = Mth.m_14036_((float)(sq2LookDirDot * sq2LookDirDot + 0.005f), (float)0.5f, (float)1.0f);
        float scale = distance * focusScale * 0.005f;
        poseStack.m_85836_();
        poseStack.m_85837_(resultPos.f_82479_, resultPos.f_82480_, resultPos.f_82481_);
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(yaw));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        poseStack.m_85841_(-scale, -scale, scale);
        if (lookDirDot > 0.999f && label != null) {
            Component text = displayDistance > 0.0f ? AbstractScanResultProvider.withDistance(label, Mth.m_14167_((float)displayDistance)) : label;
            Font font = Minecraft.m_91087_().f_91062_;
            int width = font.m_92852_((FormattedText)text) + 16;
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)width / 2.0f), 0.0, 0.0);
            VertexConsumer vertexConsumer = bufferSource.m_6299_(AbstractScanResultProvider.getRenderLayer());
            float f = width;
            Objects.requireNonNull(font);
            AbstractScanResultProvider.drawQuad(vertexConsumer, poseStack, f, 9 + 5, 0.0f, 0.0f, 0.0f, 0.6f);
            poseStack.m_85849_();
            font.m_92841_(text, 12.0f, -4.0f, -1, true, poseStack.m_85850_().m_85861_(), bufferSource, true, 0, 0xF000F0);
        }
        AbstractScanResultProvider.drawQuad(bufferSource.m_6299_(AbstractScanResultProvider.getRenderLayer(icon)), poseStack, 16.0f, 16.0f);
        poseStack.m_85849_();
    }

    protected static void drawQuad(VertexConsumer buffer, PoseStack poseStack, float width, float height) {
        AbstractScanResultProvider.drawQuad(buffer, poseStack, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected static void drawQuad(VertexConsumer buffer, PoseStack poseStack, float width, float height, float r, float g, float b, float a) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        buffer.m_85982_(matrix, -width * 0.5f, height * 0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix, width * 0.5f, height * 0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix, width * 0.5f, -height * 0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, -width * 0.5f, -height * 0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_5752_();
    }

    protected static RenderType getRenderLayer() {
        return RenderType.m_173215_((String)"scan_result", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)65536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110685_(RenderType.f_110139_).m_110663_(RenderStateShard.f_110111_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
    }

    protected static RenderType getRenderLayer(ResourceLocation textureLocation) {
        return RenderType.m_173215_((String)"scan_result", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)65536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172817_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false, false)).m_110685_(RenderType.f_110139_).m_110663_(RenderStateShard.f_110111_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
    }

    private static Component withDistance(Component caption, float distance) {
        return Component.m_237110_((String)"gui.scannable.overlay.distance", (Object[])new Object[]{caption, Mth.m_14167_((float)distance)});
    }
}

