/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class BlockCacheScanFilter
implements Predicate<BlockState> {
    private final Collection<Block> blocks;

    public BlockCacheScanFilter(Collection<Predicate<BlockState>> filters) {
        this.blocks = BlockCacheScanFilter.buildCache(filters);
    }

    public BlockCacheScanFilter(List<Block> blocks) {
        this.blocks = new HashSet<Block>(blocks);
    }

    @Override
    public boolean test(BlockState state) {
        return this.blocks.contains(state.m_60734_());
    }

    private static Collection<Block> buildCache(Collection<Predicate<BlockState>> filters) {
        HashSet<Block> cache = new HashSet<Block>();
        Registry.f_122824_.forEach(block -> {
            BlockState blockState = block.m_49966_();
            if (filters.stream().anyMatch(f -> f.test(blockState))) {
                cache.add(blockState.m_60734_());
            }
        });
        return cache;
    }
}

