/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.shader;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public final class Shaders
implements ResourceManagerReloadListener {
    private static final Shaders INSTANCE = new Shaders();
    private static final List<ShaderReference> SHADERS = new ArrayList<ShaderReference>();
    public static ShaderInstance scanEffectShader;
    public static ShaderInstance scanResultShader;

    public static void initialize() {
        Shaders.addShader("scan_effect", DefaultVertexFormat.f_85817_, shader -> {
            scanEffectShader = shader;
        });
        Shaders.addShader("scan_result", DefaultVertexFormat.f_85819_, shader -> {
            scanResultShader = shader;
        });
        Shaders.loadAndListenToReload();
    }

    @Nullable
    public static ShaderInstance getScanEffectShader() {
        return scanEffectShader;
    }

    @Nullable
    public static ShaderInstance getScanResultShader() {
        return scanResultShader;
    }

    public void m_6213_(ResourceManager manager) {
        Shaders.reloadShaders((ResourceProvider)manager);
    }

    private static void loadAndListenToReload() {
        Minecraft.m_91087_().m_18689_(() -> {
            ResourceManager manager = Minecraft.m_91087_().m_91098_();
            INSTANCE.m_6213_(manager);
            if (manager instanceof ReloadableResourceManager) {
                ReloadableResourceManager reloadableManager = (ReloadableResourceManager)manager;
                reloadableManager.m_7217_((PreparableReloadListener)INSTANCE);
            }
        });
    }

    private static void reloadShaders(ResourceProvider provider) {
        RenderSystem.m_187554_();
        SHADERS.forEach(reference -> reference.reload(provider));
    }

    private static void addShader(String name, VertexFormat format, Consumer<ShaderInstance> reloadAction) {
        SHADERS.add(new ShaderReference(name, format, reloadAction));
    }

    private Shaders() {
    }

    private static final class ShaderReference {
        private static final Logger LOGGER = LogManager.getLogger();
        private final String name;
        private final VertexFormat format;
        private final Consumer<ShaderInstance> reloadAction;
        private ShaderInstance shader;

        public ShaderReference(String name, VertexFormat format, Consumer<ShaderInstance> reloadAction) {
            this.name = name;
            this.format = format;
            this.reloadAction = reloadAction;
        }

        public void reload(ResourceProvider provider) {
            if (this.shader != null) {
                this.shader.close();
                this.shader = null;
            }
            try {
                this.shader = new ShaderInstance(location -> provider.m_213713_(new ResourceLocation("scannable", location.m_135815_())).or(() -> provider.m_213713_(location)), this.name, this.format);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            this.reloadAction.accept(this.shader);
        }
    }
}

