/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.energy.forge;

import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.item.Items;
import li.cil.scannable.common.item.ScannerItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.energy.EnergyStorage;

public final class ScannerEnergyStorage
extends EnergyStorage {
    private static final String TAG_ENERGY = "energy";
    private final ItemStack container;

    public ScannerEnergyStorage(ItemStack container) {
        super(CommonConfig.energyCapacityScanner);
        this.container = container;
        CompoundTag tag = container.m_41783_();
        if (tag != null && tag.m_128425_(TAG_ENERGY, 3)) {
            this.deserializeNBT(tag.m_128423_(TAG_ENERGY));
        }
    }

    public static ScannerEnergyStorage of(ItemStack container) {
        if (container.m_41720_() instanceof ScannerItem) {
            return new ScannerEnergyStorage(container);
        }
        return new ScannerEnergyStorage(new ItemStack((ItemLike)Items.SCANNER.get()));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!CommonConfig.useEnergy) {
            return 0;
        }
        int energyReceived = super.receiveEnergy(maxReceive, simulate);
        if (!simulate && energyReceived != 0) {
            this.container.m_41700_(TAG_ENERGY, this.serializeNBT());
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!CommonConfig.useEnergy) {
            return 0;
        }
        int energyExtracted = super.extractEnergy(maxExtract, simulate);
        if (!simulate && energyExtracted != 0) {
            this.container.m_41700_(TAG_ENERGY, this.serializeNBT());
        }
        return energyExtracted;
    }
}

