/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.container.BlockModuleContainerMenu;
import li.cil.scannable.common.item.ScannerModuleItem;
import li.cil.scannable.common.scanning.ConfigurableBlockScannerModule;
import li.cil.scannable.common.scanning.filter.IgnoredBlocks;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigurableBlockScannerModuleItem
extends ScannerModuleItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TAG_BLOCKS = "blocks";
    private static final String TAG_IS_LOCKED = "isLocked";

    public static boolean isLocked(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(TAG_IS_LOCKED);
    }

    public static List<Block> getBlocks(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_(TAG_BLOCKS, 9)) {
            return Collections.emptyList();
        }
        ListTag list = tag.m_128437_(TAG_BLOCKS, 8);
        ArrayList<Block> result = new ArrayList<Block>();
        list.forEach(item -> {
            try {
                ResourceLocation registryName = new ResourceLocation(item.m_7916_());
                Registry.f_122824_.m_6612_(registryName).ifPresent(result::add);
            }
            catch (ResourceLocationException e) {
                LOGGER.error((Object)e);
            }
        });
        return result;
    }

    public static boolean addBlock(ItemStack stack, Block block) {
        Optional registryName = Registry.f_122824_.m_7854_((Object)block);
        if (registryName.isEmpty()) {
            return false;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_LOCKED)) {
            return false;
        }
        StringTag itemNbt = StringTag.m_129297_((String)((ResourceKey)registryName.get()).m_135782_().toString());
        ListTag list = tag.m_128437_(TAG_BLOCKS, 8);
        if (list.contains((Object)itemNbt)) {
            return true;
        }
        if (list.size() >= 5) {
            return false;
        }
        tag.m_128365_(TAG_BLOCKS, (Tag)list);
        list.add((Object)itemNbt);
        return true;
    }

    public static void setBlockAt(ItemStack stack, int index, Block block) {
        if (index < 0 || index >= 5) {
            return;
        }
        Optional registryName = Registry.f_122824_.m_7854_((Object)block);
        if (registryName.isEmpty()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_LOCKED)) {
            return;
        }
        StringTag itemNbt = StringTag.m_129297_((String)((ResourceKey)registryName.get()).m_135782_().toString());
        ListTag list = tag.m_128437_(TAG_BLOCKS, 8);
        int oldIndex = list.indexOf((Object)itemNbt);
        if (oldIndex == index) {
            return;
        }
        if (index >= list.size()) {
            list.add((Object)itemNbt);
        } else {
            list.set(index, (Tag)itemNbt);
        }
        if (oldIndex >= 0) {
            list.remove(oldIndex);
        }
        tag.m_128365_(TAG_BLOCKS, (Tag)list);
    }

    public static void removeBlockAt(ItemStack stack, int index) {
        if (index < 0 || index >= 5) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_LOCKED)) {
            return;
        }
        ListTag list = tag.m_128437_(TAG_BLOCKS, 8);
        if (index < list.size()) {
            list.remove(index);
        }
    }

    public ConfigurableBlockScannerModuleItem() {
        super(ConfigurableBlockScannerModule.INSTANCE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        List<Block> blocks = ConfigurableBlockScannerModuleItem.getBlocks(stack);
        if (!blocks.isEmpty()) {
            tooltip.add(Strings.TOOLTIP_BLOCKS_LIST_CAPTION);
            blocks.forEach(b -> tooltip.add(Strings.listItem((Component)b.m_49954_())));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, final InteractionHand hand) {
        final ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return stack.m_41786_();
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    return new BlockModuleContainerMenu(id, inventory, hand);
                }
            }, buffer -> buffer.m_130068_((Enum)hand));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_46859_(context.m_8083_())) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        BlockState state = level.m_8055_(context.m_8083_());
        if (IgnoredBlocks.contains(state)) {
            if (!level.m_5776_()) {
                player.m_5661_(Strings.MESSAGE_BLOCK_IGNORED, true);
            }
            player.m_36335_().m_41524_((Item)this, 10);
            return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
        }
        if (!(ConfigurableBlockScannerModuleItem.addBlock(stack, state.m_60734_()) || level.m_5776_() || ConfigurableBlockScannerModuleItem.isLocked(stack))) {
            player.m_5661_(Strings.MESSAGE_NO_FREE_SLOTS, true);
        }
        return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
    }
}

