/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.client.audio.SoundManager;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.container.ScannerContainerMenu;
import li.cil.scannable.common.energy.ItemEnergyStorage;
import li.cil.scannable.common.inventory.ContainerSlice;
import li.cil.scannable.common.inventory.ScannerContainer;
import li.cil.scannable.common.item.Items;
import li.cil.scannable.common.item.ModItem;
import li.cil.scannable.common.item.ScannerModuleItem;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class ScannerItem
extends ModItem {
    public static boolean isScanner(ItemStack stack) {
        return stack.m_41720_() == Items.SCANNER.get();
    }

    public ScannerItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (this.m_220152_(group) && CommonConfig.useEnergy) {
            ItemStack stack = new ItemStack((ItemLike)this);
            ItemEnergyStorage.of(stack).ifPresent(energy -> {
                energy.receiveEnergy(Integer.MAX_VALUE, false);
                items.add((Object)stack);
            });
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (CommonConfig.useEnergy) {
            ItemEnergyStorage.of(stack).ifPresent(energy -> tooltip.add(Strings.energyStorage(energy.getEnergyStored(), energy.getMaxEnergyStored())));
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return CommonConfig.useEnergy;
    }

    public int m_142158_(ItemStack stack) {
        return (int)(ScannerItem.getRelativeEnergy(stack) * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(ScannerItem.getRelativeEnergy(stack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, final InteractionHand hand) {
        final ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return stack.m_41786_();
                    }

                    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                        return new ScannerContainerMenu(id, inventory, hand, ScannerContainer.of(stack));
                    }
                }, buffer -> buffer.m_130068_((Enum)hand));
            }
        } else {
            ArrayList<ItemStack> modules = new ArrayList<ItemStack>();
            if (!ScannerItem.collectModules(stack, modules)) {
                if (!level.m_5776_()) {
                    player.m_5661_(Strings.MESSAGE_NO_SCAN_MODULES, true);
                }
                player.m_36335_().m_41524_((Item)this, 10);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (!ScannerItem.tryConsumeEnergy(player, stack, modules, true)) {
                if (!level.m_5776_()) {
                    player.m_5661_(Strings.MESSAGE_NOT_ENOUGH_ENERGY, true);
                }
                player.m_36335_().m_41524_((Item)this, 10);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6672_(hand);
            if (level.m_5776_()) {
                ScanManager.beginScan(player, modules);
                SoundManager.playChargingSound();
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        return 40;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        super.m_5929_(level, entity, stack, count);
        if (entity.f_19853_.m_5776_()) {
            ScanManager.updateScan((Entity)entity, false);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (level.m_5776_()) {
            ScanManager.cancelScan();
            SoundManager.stopChargingSound();
        }
        super.m_5551_(stack, level, entity, timeLeft);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        ArrayList<ItemStack> modules = new ArrayList<ItemStack>();
        if (!ScannerItem.collectModules(stack, modules)) {
            return stack;
        }
        boolean hasEnergy = ScannerItem.tryConsumeEnergy((Player)entity, stack, modules, false);
        if (level.m_5776_()) {
            SoundManager.stopChargingSound();
            if (hasEnergy) {
                ScanManager.updateScan((Entity)entity, true);
                SoundManager.playActivateSound();
            } else {
                ScanManager.cancelScan();
            }
        }
        player.m_36335_().m_41524_((Item)this, 40);
        return stack;
    }

    private static float getRelativeEnergy(ItemStack stack) {
        if (!CommonConfig.useEnergy) {
            return 0.0f;
        }
        return ItemEnergyStorage.of(stack).map(storage -> Float.valueOf((float)storage.getEnergyStored() / (float)storage.getMaxEnergyStored())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static boolean tryConsumeEnergy(Player player, ItemStack scanner, List<ItemStack> modules, boolean simulate) {
        if (!CommonConfig.useEnergy) {
            return true;
        }
        if (player.m_7500_()) {
            return true;
        }
        Optional<ItemEnergyStorage> energyStorage = ItemEnergyStorage.of(scanner);
        if (energyStorage.isEmpty()) {
            return false;
        }
        long totalCostAccumulator = 0L;
        for (ItemStack module : modules) {
            totalCostAccumulator += (long)ScannerModuleItem.getModuleEnergyCost(module);
        }
        long totalCost = totalCostAccumulator;
        long extracted = energyStorage.map(storage -> storage.extractEnergy(totalCost, simulate)).orElse(0L);
        return extracted >= totalCost;
    }

    private static boolean collectModules(ItemStack scanner, List<ItemStack> modules) {
        ScannerContainer container = ScannerContainer.of(scanner);
        ContainerSlice activeModules = container.getActiveModules();
        boolean hasScannerModules = false;
        for (int slot = 0; slot < activeModules.m_6643_(); ++slot) {
            ItemStack module = activeModules.m_8020_(slot);
            if (module.m_41619_()) continue;
            modules.add(module);
            hasScannerModules |= ScannerModuleItem.getModule(module).map(ScannerModule::hasResultProvider).orElse(false).booleanValue();
        }
        return hasScannerModules;
    }
}

