/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import li.cil.scannable.common.config.CommonConfig;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public enum IgnoredBlocks {
    INSTANCE;

    private Set<Block> ignoredBlocks;

    public static void clearCache() {
        IgnoredBlocks.INSTANCE.ignoredBlocks = null;
    }

    public static boolean contains(BlockState state) {
        INSTANCE.validateFilter();
        return IgnoredBlocks.INSTANCE.ignoredBlocks.contains(state.m_60734_());
    }

    private void validateFilter() {
        if (this.ignoredBlocks != null) {
            return;
        }
        HashSet<Block> ignoredBlocks = new HashSet<Block>();
        for (ResourceLocation location : CommonConfig.ignoredBlocks) {
            Registry.f_122824_.m_6612_(location).ifPresent(ignoredBlocks::add);
        }
        ArrayList ignoredTags = new ArrayList();
        Registry.f_122824_.m_203613_().forEach(namedTag -> {
            if (CommonConfig.ignoredBlockTags.contains(namedTag.f_203868_())) {
                ignoredTags.add(namedTag);
            }
        });
        for (Block block : Registry.f_122824_) {
            BlockState blockState = block.m_49966_();
            if (!ignoredTags.stream().anyMatch(arg_0 -> ((BlockState)blockState).m_204336_(arg_0))) continue;
            ignoredBlocks.add(blockState.m_60734_());
        }
        this.ignoredBlocks = ignoredBlocks;
    }
}

