/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.item.CompoundPartItem;

public class LazyPartData
implements IPartData {
    private final ResourceLocation partId;
    private final ItemStack craftingItem;

    public LazyPartData(ResourceLocation partId) {
        this(partId, ItemStack.f_41583_);
    }

    public LazyPartData(ResourceLocation partId, ItemStack craftingItem) {
        this.partId = partId;
        this.craftingItem = craftingItem;
    }

    public static LazyPartData of(ResourceLocation partId) {
        return new LazyPartData(partId);
    }

    public static LazyPartData of(ResourceLocation partId, ItemStack craftingItem) {
        return new LazyPartData(partId, craftingItem);
    }

    public static LazyPartData of(DataResource<IGearPart> part, ItemStack craftingItem) {
        return new LazyPartData(part.getId(), craftingItem);
    }

    public static LazyPartData of(DataResource<IGearPart> part, CompoundPartItem partItem, List<LazyMaterialInstance> materials) {
        return new LazyPartData(part.getId(), partItem.create(materials));
    }

    public static LazyPartData of(DataResource<IGearPart> part, CompoundPartItem partItem, LazyMaterialInstance material) {
        return LazyPartData.of(part, partItem, Collections.singletonList(material));
    }

    public static LazyPartData of(DataResource<IGearPart> part, CompoundPartItem partItem, DataResource<IMaterial> material) {
        return LazyPartData.of(part, partItem, LazyMaterialInstance.of(material));
    }

    @Override
    public ResourceLocation getId() {
        return this.partId;
    }

    @Override
    @Nullable
    public IGearPart get() {
        return PartManager.get(this.partId);
    }

    @Override
    public ItemStack getItem() {
        if (!this.craftingItem.m_41619_()) {
            return this.craftingItem;
        }
        IGearPart part = this.get();
        if (part == null) {
            return ItemStack.f_41583_;
        }
        return PartData.of(part).getItem();
    }

    @Override
    public Component getDisplayName(PartType type, ItemStack gear) {
        IGearPart part = this.get();
        return part != null ? part.getDisplayName(this, type, gear) : Component.m_237113_((String)"INVALID");
    }

    @Override
    public CompoundTag write(CompoundTag tags) {
        tags.m_128359_("ID", this.partId.toString());
        if (!this.craftingItem.m_41619_()) {
            tags.m_128365_("Item", (Tag)this.craftingItem.m_41739_(new CompoundTag()));
        }
        return tags;
    }

    @Override
    public String getModelKey() {
        return SilentGear.shortenId(this.partId);
    }

    public boolean isValid() {
        return this.get() != null;
    }

    public static LazyPartData deserialize(JsonElement json) {
        if (json.isJsonPrimitive()) {
            String key = json.getAsString();
            return new LazyPartData(new ResourceLocation(key));
        }
        JsonObject jo = json.getAsJsonObject();
        ResourceLocation partId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jo, (String)"part"));
        if (!jo.has("item")) {
            return LazyPartData.of(partId);
        }
        Item item = GsonHelper.m_13909_((JsonObject)jo, (String)"item");
        if (!(item instanceof CompoundPartItem)) {
            throw new JsonSyntaxException("Item " + item + " is not a compound part item. Try using \"part\" instead.");
        }
        if (!jo.has("materials") || !jo.get("materials").isJsonArray()) {
            throw new JsonSyntaxException("\"materials\" is either missing or not a JSON array");
        }
        List<LazyMaterialInstance> materials = LazyPartData.deserializeMaterials(GsonHelper.m_13933_((JsonObject)jo, (String)"materials"));
        return LazyPartData.of(DataResource.part(partId), (CompoundPartItem)item, materials);
    }

    private static List<LazyMaterialInstance> deserializeMaterials(JsonArray json) {
        ArrayList materials = Lists.newArrayList();
        for (JsonElement je : json) {
            materials.add(LazyMaterialInstance.deserialize(je));
        }
        return materials;
    }

    public static List<PartData> createPartList(Collection<LazyPartData> parts) {
        ArrayList<PartData> list = new ArrayList<PartData>();
        for (LazyPartData lazy : parts) {
            IGearPart gearPart = lazy.get();
            if (gearPart == null) continue;
            PartData part = PartData.of(gearPart, lazy.craftingItem);
            list.add(part);
        }
        return list;
    }
}

