/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.util.TextUtil;

public class FragmentItem
extends Item {
    private static final String NBT_MATERIAL = "Material";

    public FragmentItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack create(IMaterialInstance material, int count) {
        ItemStack stack = new ItemStack((ItemLike)this, count);
        stack.m_41784_().m_128365_(NBT_MATERIAL, (Tag)material.write(new CompoundTag()));
        return stack;
    }

    @Nullable
    public static IMaterialInstance getMaterial(ItemStack stack) {
        if (stack.m_41784_().m_128425_(NBT_MATERIAL, 10)) {
            return MaterialInstance.read(stack.m_41784_().m_128469_(NBT_MATERIAL));
        }
        ResourceLocation id = ResourceLocation.m_135820_((String)stack.m_41784_().m_128461_(NBT_MATERIAL));
        IMaterial material = MaterialManager.get(id);
        if (material != null) {
            return MaterialInstance.of(material);
        }
        return null;
    }

    public static String getModelKey(ItemStack stack) {
        MaterialInstance material;
        if (stack.m_41784_().m_128425_(NBT_MATERIAL, 10) && (material = MaterialInstance.read(stack.m_41784_().m_128469_(NBT_MATERIAL))) != null) {
            return material.getModelKey();
        }
        return stack.m_41784_().m_128461_(NBT_MATERIAL);
    }

    public Component m_7626_(ItemStack stack) {
        IMaterialInstance material = FragmentItem.getMaterial(stack);
        if (material == null) {
            return Component.m_237115_((String)(this.m_5671_(stack) + ".invalid"));
        }
        return Component.m_237110_((String)this.m_5671_(stack), (Object[])new Object[]{material.getDisplayName(PartType.MAIN)});
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.m_220152_(group)) {
            return;
        }
        items.add((Object)new ItemStack((ItemLike)this));
        if (SilentGear.isDevBuild()) {
            for (IMaterial material : MaterialManager.getValues()) {
                items.add((Object)this.create(MaterialInstance.of(material), 1));
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)TextUtil.translate("item", "fragment.hint").m_130940_(ChatFormatting.ITALIC));
    }
}

