/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.util.GameUtil;

public final class ClientTicks {
    private static final ClientTicks INSTANCE = new ClientTicks();
    private static final int QUEUE_OVERFLOW_LIMIT = 200;
    private volatile Queue<Runnable> scheduledActions = new ConcurrentLinkedDeque<Runnable>();
    public int ticksInGame = 0;
    public float partialTicks = 0.0f;
    public float deltaTicks = 0.0f;
    public float totalTicks = 0.0f;

    private ClientTicks() {
        MinecraftForge.EVENT_BUS.addListener(this::clientTickEnd);
        MinecraftForge.EVENT_BUS.addListener(this::renderTick);
    }

    public static void scheduleAction(Runnable action) {
        if (GameUtil.isClient()) {
            ClientTicks.INSTANCE.scheduledActions.add(action);
        } else {
            SilentLib.LOGGER.error("Tried to add client tick action on server side? {}", (Object)action);
        }
        if (ClientTicks.INSTANCE.scheduledActions.size() >= 200) {
            SilentLib.LOGGER.warn("Too many client tick actions queued! Currently at {} items. Would have added '{}'.", (Object)ClientTicks.INSTANCE.scheduledActions.size(), (Object)action);
            SilentLib.LOGGER.catching((Throwable)new IllegalStateException("ClientTicks queue overflow"));
            ClientTicks.INSTANCE.scheduledActions.clear();
        }
    }

    private void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.runScheduledActions();
        this.updateTickCounters();
    }

    private void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.partialTicks = event.renderTickTime;
        }
    }

    private void runScheduledActions() {
        Runnable action = this.scheduledActions.poll();
        while (action != null) {
            action.run();
            action = this.scheduledActions.poll();
        }
    }

    private void updateTickCounters() {
        Screen gui = Minecraft.m_91087_().f_91080_;
        if (gui == null || !gui.m_7043_()) {
            ++this.ticksInGame;
            this.partialTicks = 0.0f;
        }
        float oldTotal = this.totalTicks;
        this.totalTicks = (float)this.ticksInGame + this.partialTicks;
        this.deltaTicks = this.totalTicks - oldTotal;
    }

    public static int ticksInGame() {
        return ClientTicks.INSTANCE.ticksInGame;
    }

    public static float partialTicks() {
        return ClientTicks.INSTANCE.partialTicks;
    }

    public static float deltaTicks() {
        return ClientTicks.INSTANCE.deltaTicks;
    }

    public static float totalTicks() {
        return ClientTicks.INSTANCE.totalTicks;
    }
}

