/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeSettingsTab;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicControl;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicControlBase;

public abstract class RefillUpgradeTab
extends UpgradeSettingsTab<RefillUpgradeContainer> {
    private static final Component SCROLL_TOOLTIP = SBPTranslationHelper.INSTANCE.translUpgrade("refill.scroll.tooltip", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY});
    private final FilterLogicControl<FilterLogic, FilterLogicContainer<FilterLogic>> filterLogicControl;
    private int slotBeingChanged = -1;
    private RefillUpgradeWrapper.TargetSlot targetSlotBeingChanged = null;
    private static List<Component> additionalTooltip = new ArrayList<Component>();

    private static void addToTooltip(ItemTooltipEvent event) {
        LocalPlayer player;
        if (!additionalTooltip.isEmpty() && (player = Minecraft.m_91087_().f_91074_) != null && player.f_36096_ instanceof BackpackContainer) {
            event.getToolTip().addAll(additionalTooltip);
        }
    }

    protected RefillUpgradeTab(RefillUpgradeContainer upgradeContainer, Position position, StorageScreenBase<?> screen, int slotsInRow, String upgradeName) {
        super((UpgradeContainerBase)upgradeContainer, position, screen, (Component)SBPTranslationHelper.INSTANCE.translUpgrade(upgradeName, new Object[0]), SBPTranslationHelper.INSTANCE.translUpgradeTooltip(upgradeName));
        this.filterLogicControl = (FilterLogicControl)this.addHideableChild((WidgetBase)new RefillFilterLogicControl(screen, slotsInRow));
    }

    protected void moveSlotsToTab() {
        this.filterLogicControl.moveSlotsToView();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.shouldRender.getAsBoolean()) {
            return;
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (!this.filterLogicControl.m_5953_((double)mouseX, (double)mouseY)) {
            this.resetAdditionalTooltip();
            if (this.slotBeingChanged > -1) {
                this.saveTargetSlot();
            }
        }
    }

    private void resetAdditionalTooltip() {
        if (!additionalTooltip.isEmpty()) {
            additionalTooltip = new ArrayList<Component>();
        }
    }

    protected void onTabClose() {
        super.onTabClose();
        this.resetAdditionalTooltip();
    }

    private void saveTargetSlot() {
        ((RefillUpgradeContainer)this.getContainer()).setTargetSlot(this.slotBeingChanged, this.targetSlotBeingChanged);
        this.slotBeingChanged = -1;
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(RefillUpgradeTab::addToTooltip);
    }

    private class RefillFilterLogicControl
    extends FilterLogicControl<FilterLogic, FilterLogicContainer<FilterLogic>> {
        private final int slotsInRow;

        public RefillFilterLogicControl(StorageScreenBase<?> screen, int slotsInRow) {
            super(screen, new Position(RefillUpgradeTab.this.x + 3, RefillUpgradeTab.this.y + 24), ((RefillUpgradeContainer)RefillUpgradeTab.this.getContainer()).getFilterLogicContainer(), slotsInRow, new FilterLogicControlBase.MatchButton[0]);
            this.slotsInRow = slotsInRow;
        }

        protected void renderWidget(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(poseStack, mouseX, mouseY, partialTicks);
            if (!((RefillUpgradeContainer)RefillUpgradeTab.this.getContainer()).allowsTargetSlotSelection()) {
                return;
            }
            this.renderTargetSlotAcronyms(poseStack);
            this.updateTargetSlotTooltip(mouseX, mouseY);
        }

        private void updateTargetSlotTooltip(int mouseX, int mouseY) {
            if (this.m_5953_(mouseX, mouseY)) {
                int slot = this.getSlot(mouseX, mouseY);
                if (RefillUpgradeTab.this.slotBeingChanged > -1) {
                    this.updateTooltip(RefillUpgradeTab.this.targetSlotBeingChanged);
                } else {
                    RefillUpgradeWrapper.TargetSlot targetSlot = ((RefillUpgradeContainer)RefillUpgradeTab.this.getContainer()).getTargetSlot(slot);
                    if (additionalTooltip.isEmpty() || !additionalTooltip.get(0).equals(targetSlot.getDescription())) {
                        this.updateTooltip(targetSlot);
                    }
                }
            }
        }

        private void renderTargetSlotAcronyms(PoseStack poseStack) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 300.0);
            ((RefillUpgradeContainer)RefillUpgradeTab.this.getContainer()).getSlots().forEach(slot -> {
                if (!slot.m_7993_().m_41619_()) {
                    int slotIndex = slot.getSlotIndex();
                    RefillUpgradeWrapper.TargetSlot ts = ((RefillUpgradeContainer)RefillUpgradeTab.this.getContainer()).getTargetSlot(slotIndex);
                    RefillUpgradeWrapper.TargetSlot targetSlot = RefillUpgradeTab.this.slotBeingChanged == slotIndex ? RefillUpgradeTab.this.targetSlotBeingChanged : ts;
                    RefillFilterLogicControl.m_93243_((PoseStack)poseStack, (Font)this.font, (Component)targetSlot.getAcronym(), (int)(this.getX() + slotIndex % this.slotsInRow * 18 + 10), (int)(this.getY() + slotIndex / this.slotsInRow * 18 + 2), (int)DyeColor.GREEN.m_41071_());
                }
            });
            poseStack.m_85849_();
        }

        private void updateTooltip(RefillUpgradeWrapper.TargetSlot targetSlot) {
            RefillUpgradeTab.this.resetAdditionalTooltip();
            additionalTooltip.add((Component)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.tooltip", new Object[]{targetSlot.getDescription()}).m_130940_(ChatFormatting.GRAY));
            additionalTooltip.add(SCROLL_TOOLTIP);
        }

        public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            int slot = this.getSlot(mouseX, mouseY);
            if (RefillUpgradeTab.this.slotBeingChanged > -1 && RefillUpgradeTab.this.slotBeingChanged != slot) {
                RefillUpgradeTab.this.saveTargetSlot();
            }
        }

        public boolean m_6050_(double mouseX, double mouseY, double pDelta) {
            int slot = this.getSlot(mouseX, mouseY);
            if (RefillUpgradeTab.this.slotBeingChanged == -1) {
                RefillUpgradeTab.this.slotBeingChanged = slot;
                RefillUpgradeTab.this.targetSlotBeingChanged = ((RefillUpgradeContainer)RefillUpgradeTab.this.getContainer()).getTargetSlot(slot);
            }
            RefillUpgradeTab.this.targetSlotBeingChanged = pDelta > 0.0 ? RefillUpgradeTab.this.targetSlotBeingChanged.next() : RefillUpgradeTab.this.targetSlotBeingChanged.previous();
            return true;
        }

        private int getSlot(double mouseX, double mouseY) {
            return ((int)mouseX - this.getX()) / 18 + this.slotsInRow * (((int)mouseY - this.getY()) / 18);
        }
    }

    public static class Advanced
    extends RefillUpgradeTab {
        public Advanced(RefillUpgradeContainer upgradeContainer, Position position, StorageScreenBase<?> screen, int slotsInRow) {
            super(upgradeContainer, position, screen, slotsInRow, "advanced_refill");
        }
    }

    public static class Basic
    extends RefillUpgradeTab {
        public Basic(RefillUpgradeContainer upgradeContainer, Position position, StorageScreenBase<?> screen, int slotsInRow) {
            super(upgradeContainer, position, screen, slotsInRow, "refill");
        }
    }
}

