/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.api.modules;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.client.guis.buttons.ButtonBase;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.ButtonComparator;
import vswe.stevescarts.helpers.SimulationInfo;
import vswe.stevescarts.network.PacketHandler;
import vswe.stevescarts.network.packets.PacketGuiData;
import vswe.stevescarts.network.packets.PacketMinecartButton;
import vswe.stevescarts.polylib.NBTHelper;

public abstract class ModuleBase {
    private final EntityMinecartModular cart;
    @Nonnull
    private final NonNullList<ItemStack> cargo;
    private int offSetX;
    private int offSetY;
    private int guiDataOffset;
    private int packetOffset;
    private ArrayList<ButtonBase> buttons;
    protected int slotGlobalStart;
    private ResourceLocation moduleId;
    private ArrayList<ModelCartbase> models;
    protected ArrayList<SlotBase> slotList;
    private int moduleButtonId = 0;

    public ModuleBase(EntityMinecartModular cart) {
        this.cart = cart;
        this.cargo = NonNullList.m_122780_((int)this.getInventorySize(), (Object)ItemStack.f_41583_);
    }

    public void init() {
        if (this.useButtons()) {
            this.buttons = new ArrayList();
            this.loadButtons();
            this.buttonVisibilityChanged();
        }
    }

    public void preInit() {
    }

    public EntityMinecartModular getCart() {
        return this.cart;
    }

    public boolean isPlaceholder() {
        return this.getCart().isPlaceholder;
    }

    protected SimulationInfo getSimInfo() {
        return this.getCart().placeholderAsssembler.getSimulationInfo();
    }

    public void setModuleId(ResourceLocation val) {
        this.moduleId = val;
    }

    public ResourceLocation getModuleId() {
        return this.moduleId;
    }

    public void onInventoryChanged() {
    }

    public int getX() {
        if (this.doStealInterface()) {
            return 0;
        }
        return this.offSetX;
    }

    public int getY() {
        if (this.doStealInterface()) {
            return 0;
        }
        return this.offSetY;
    }

    public void setX(int val) {
        this.offSetX = val;
    }

    public void setY(int val) {
        this.offSetY = val;
    }

    public int getInventorySize() {
        if (!this.hasSlots()) {
            return 0;
        }
        return this.getInventoryWidth() * this.getInventoryHeight();
    }

    public int guiWidth() {
        return 15 + this.getInventoryWidth() * 18;
    }

    public int guiHeight() {
        return 27 + this.getInventoryHeight() * 18;
    }

    protected int getInventoryWidth() {
        return 3;
    }

    protected int getInventoryHeight() {
        return 1;
    }

    public void keyPress(GuiMinecart gui, int id, int extraInformation) {
    }

    public ArrayList<SlotBase> getSlots() {
        return this.slotList;
    }

    public int generateSlots(int slotCount) {
        this.slotGlobalStart = slotCount;
        this.slotList = new ArrayList();
        for (int j = 0; j < this.getInventoryHeight(); ++j) {
            for (int i = 0; i < this.getInventoryWidth(); ++i) {
                this.slotList.add(this.getSlot(slotCount++, i, j));
            }
        }
        return slotCount;
    }

    protected SlotBase getSlot(int slotId, int x, int y) {
        return null;
    }

    public boolean hasSlots() {
        return this.hasGui();
    }

    public void update() {
    }

    public boolean hasFuel(int consumption) {
        return false;
    }

    public float getMaxSpeed() {
        return 1.1f;
    }

    public int getYTarget() {
        return -1;
    }

    public void moveMinecartOnRail(BlockPos pos) {
    }

    @Nonnull
    public ItemStack getStack(int slot) {
        return (ItemStack)this.cargo.get(slot);
    }

    public void setStack(int slot, @Nonnull ItemStack item) {
        this.cargo.set(slot, (Object)item);
    }

    public void addStack(int slotStart, int slotEnd, @Nonnull ItemStack item) {
        this.getCart().addItemToChest(item, this.slotGlobalStart + slotStart, this.slotGlobalStart + slotEnd);
    }

    public void addStack(int slot, @Nonnull ItemStack item) {
        this.addStack(slot, slot, item);
    }

    public boolean dropOnDeath() {
        return true;
    }

    public void onDeath() {
    }

    public boolean hasGui() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawString(PoseStack matrixStack, GuiMinecart gui, String str, int[] rect, int c) {
        if (rect.length < 4) {
            return;
        }
        int n = rect[0] + (rect[2] - Minecraft.m_91087_().f_91062_.m_92895_(str)) / 2;
        int n2 = rect[1];
        int n3 = rect[3];
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.drawString(matrixStack, gui, str, n, n2 + (n3 - 9 + 3) / 2, c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawString(PoseStack matrixStack, GuiMinecart gui, String str, int x, int y, int c) {
        this.drawString(matrixStack, gui, str, x, y, -1, false, c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawString(PoseStack matrixStack, GuiMinecart gui, String str, int x, int y, int w, boolean center, int c) {
        int left = gui.getGuiLeft();
        int top = gui.getGuiTop();
        int[] rect = new int[]{x, y, w, 8};
        boolean stealInterface = this.doStealInterface();
        int dif = 0;
        if (!stealInterface) {
            dif = this.handleScroll(rect);
        }
        if (rect[3] > 0) {
            if (!stealInterface) {
                gui.pushScissor();
            }
            if (center) {
                Minecraft.m_91087_().f_91062_.m_92883_(matrixStack, str, (float)(rect[0] + (rect[2] - Minecraft.m_91087_().f_91062_.m_92895_(str)) / 2 + this.getX() + left), (float)(rect[1] + this.getY() + dif + top), c);
            } else {
                Minecraft.m_91087_().f_91062_.m_92883_(matrixStack, str, (float)(rect[0] + this.getX() + left), (float)(rect[1] + this.getY() + dif + top), c);
            }
            if (!stealInterface) {
                gui.popScissor();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawStringWithShadow(PoseStack matrixStack, GuiMinecart gui, String str, int x, int y, int c) {
        int j = gui.getGuiLeft();
        int k = gui.getGuiTop();
        int[] rect = new int[]{x, y, 0, 8};
        if (!this.doStealInterface()) {
            this.handleScroll(rect);
        }
        if (rect[3] == 8) {
            Minecraft.m_91087_().f_91062_.m_92750_(matrixStack, str, (float)(rect[0] + this.getX()), (float)(rect[1] + this.getY()), c);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawSplitString(GuiMinecart gui, String str, int x, int y, int w, int c) {
        this.drawSplitString(gui, str, x, y, w, false, c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawSplitString(GuiMinecart gui, String str, int x, int y, int w, boolean center, int c) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawItemInInterface(GuiMinecart gui, @Nonnull ItemStack item, int x, int y) {
        int[] rect = new int[]{x, y, 16, 16};
        this.handleScroll(rect);
        if (rect[3] == 16) {
            ItemRenderer renderitem = Minecraft.m_91087_().m_91291_();
            renderitem.m_115123_(item, gui.getGuiLeft() + rect[0] + this.getX(), gui.getGuiTop() + rect[1] + this.getY());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(PoseStack matrixStack, GuiMinecart gui, int targetX, int targetY, int srcX, int srcY, int sizeX, int sizeY) {
        this.drawImage(matrixStack, gui, targetX, targetY, srcX, srcY, sizeX, sizeY, GuiMinecart.RENDER_ROTATION.NORMAL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(PoseStack matrixStack, GuiMinecart gui, int targetX, int targetY, int srcX, int srcY, int sizeX, int sizeY, GuiMinecart.RENDER_ROTATION rotation) {
        this.drawImage(matrixStack, gui, new int[]{targetX, targetY, sizeX, sizeY}, srcX, srcY, rotation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(PoseStack matrixStack, GuiMinecart gui, int[] rect, int srcX, int srcY) {
        this.drawImage(matrixStack, gui, rect, srcX, srcY, GuiMinecart.RENDER_ROTATION.NORMAL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(PoseStack matrixStack, GuiMinecart gui, int[] rect, int srcX, int srcY, GuiMinecart.RENDER_ROTATION rotation) {
        if (rect.length < 4) {
            return;
        }
        rect = this.cloneRect(rect);
        if (!this.doStealInterface()) {
            srcY -= this.handleScroll(rect);
        }
        if (rect[3] > 0) {
            gui.drawTexturedModalRect(matrixStack, gui.getGuiLeft() + rect[0] + this.getX(), gui.getGuiTop() + rect[1] + this.getY(), srcX, srcY, rect[2], rect[3], rotation);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiMinecart gui, TextureAtlasSprite icon, int targetX, int targetY, int sizeX, int sizeY) {
        this.drawImage(gui, icon, new int[]{targetX, targetY, sizeX, sizeY});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiMinecart gui, TextureAtlasSprite icon, int[] rect) {
        if (rect.length < 4) {
            return;
        }
        rect = this.cloneRect(rect);
        if (!this.doStealInterface()) {
            this.handleScroll(rect);
        }
        if (rect[3] > 0) {
            GuiComponent.m_93200_((PoseStack)new PoseStack(), (int)(gui.getGuiLeft() + rect[0] + this.getX()), (int)(gui.getGuiTop() + rect[1] + this.getY()), (int)0, (int)rect[2], (int)rect[3], (TextureAtlasSprite)icon);
        }
    }

    public int handleScroll(int[] rect) {
        rect[1] = rect[1] - this.getCart().getRealScrollY();
        int y = rect[1] + this.getY();
        if (y < 4) {
            int dif = y - 4;
            rect[3] = rect[3] + dif;
            y = 4;
            rect[1] = y - this.getY();
            return dif;
        }
        if (y + rect[3] > 168) {
            rect[3] = Math.max(0, 168 - y);
            return 0;
        }
        return 0;
    }

    protected int[] cloneRect(int[] rect) {
        return new int[]{rect[0], rect[1], rect[2], rect[3]};
    }

    public boolean useButtons() {
        return false;
    }

    public final void buttonVisibilityChanged() {
        this.buttons.sort(ButtonComparator.INSTANCE);
        ButtonBase.LOCATION lastLoc = null;
        int id = 0;
        for (ButtonBase button : this.buttons) {
            if (!button.isVisible()) continue;
            if (lastLoc != null && button.getLocation() != lastLoc) {
                id = 0;
            }
            lastLoc = button.getLocation();
            button.setCurrentID(id);
            ++id;
        }
    }

    public RAILDIRECTION getSpecialRailDirection(BlockPos pos) {
        return RAILDIRECTION.DEFAULT;
    }

    protected void loadButtons() {
    }

    public final void addButton(ButtonBase button) {
        button.setIdInModule(this.moduleButtonId++);
        this.buttons.add(button);
    }

    public String generateNBTName(String name, int id) {
        return "module" + id + name;
    }

    public final void writeToNBT(CompoundTag tagCompound, int id) {
        if (this.getInventorySize() > 0) {
            ListTag items = new ListTag();
            for (int i = 0; i < this.getInventorySize(); ++i) {
                if (this.getStack(i).m_41619_()) continue;
                CompoundTag item = new CompoundTag();
                item.m_128344_("Slot", (byte)i);
                this.getStack(i).m_41739_(item);
                items.add((Object)item);
            }
            tagCompound.m_128365_(this.generateNBTName("Items", id), (Tag)items);
        }
        this.Save(tagCompound, id);
    }

    protected void Save(CompoundTag tagCompound, int id) {
    }

    public final void readFromNBT(CompoundTag tagCompound, int id) {
        if (this.getInventorySize() > 0) {
            ListTag items = tagCompound.m_128437_(this.generateNBTName("Items", id), NBTHelper.COMPOUND.getId());
            for (int i = 0; i < items.size(); ++i) {
                CompoundTag item = items.m_128728_(i);
                int slot = item.m_128445_("Slot") & 0xFF;
                if (slot < 0 || slot >= this.getInventorySize()) continue;
                this.setStack(slot, ItemStack.m_41712_((CompoundTag)item));
            }
        }
        this.Load(tagCompound, id);
    }

    protected void Load(CompoundTag tagCompound, int id) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void drawButtonText(PoseStack matrixStack, GuiMinecart gui) {
        for (ButtonBase button : this.buttons) {
            button.drawButtonText(matrixStack, gui, this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void drawButtons(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        for (ButtonBase button : this.buttons) {
            button.drawButton(matrixStack, gui, this, x, y);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void drawButtonOverlays(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        for (ButtonBase button : this.buttons) {
            if (!button.isVisible()) continue;
            this.drawStringOnMouseOver(matrixStack, gui, button.toString(), x, y, button.getBounds());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void mouseClickedButton(GuiMinecart gui, int x, int y, int mousebutton) {
        for (ButtonBase button : this.buttons) {
            if (!this.inRect(x, y, button.getBounds())) continue;
            button.computeOnClick(gui, mousebutton);
        }
    }

    public void sendButtonPacket(ButtonBase button, byte clickinfo) {
        byte id = (byte)button.getIdInModule();
        this.sendPacket(this.totalNumberOfPackets() - 1, new byte[]{id, clickinfo});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBackgroundItems(GuiMinecart gui, int x, int y) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseReleased(GuiMinecart gui, int x, int y, int button) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseMoved(GuiMinecart gui, int x, int y) {
    }

    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
    }

    protected boolean inRect(int x, int y, int x1, int y1, int sizeX, int sizeY) {
        return this.inRect(x, y, new int[]{x1, y1, sizeX, sizeY});
    }

    public boolean inRect(int x, int y, int[] rect) {
        if (rect.length < 4) {
            return false;
        }
        rect = this.cloneRect(rect);
        if (!this.doStealInterface()) {
            this.handleScroll(rect);
        }
        return rect[3] > 0 && x >= rect[0] && x <= rect[0] + rect[2] && y >= rect[1] && y <= rect[1] + rect[3];
    }

    public boolean receiveDamage(DamageSource source, float val) {
        return true;
    }

    protected void turnback() {
        for (ModuleBase module : this.getCart().getModules()) {
            if (module == this || !module.preventTurnback()) continue;
            return;
        }
        this.getCart().turnback();
    }

    protected boolean preventTurnback() {
        return false;
    }

    public final int totalNumberOfPackets() {
        return this.numberOfPackets() + (this.useButtons() ? 1 : 0);
    }

    protected int numberOfPackets() {
        return 0;
    }

    public int getPacketStart() {
        return this.packetOffset;
    }

    public void setPacketStart(int val) {
        this.packetOffset = val;
    }

    protected void sendPacket(int id) {
        this.sendPacket(id, new byte[0]);
    }

    public void sendPacket(int id, byte data) {
        this.sendPacket(id, new byte[]{data});
    }

    public void sendPacket(int id, byte[] data) {
        PacketHandler.sendToServer(new PacketMinecartButton(this.cart.m_19879_(), this.getPacketStart() + id, data));
    }

    protected void sendPacket(int id, Player player) {
        this.sendPacket(id, new byte[0], player);
    }

    protected void sendPacket(int id, byte data, Player player) {
        this.sendPacket(id, new byte[]{data}, player);
    }

    protected void sendPacket(int id, byte[] data, Player player) {
        if (player instanceof ServerPlayer) {
            PacketHandler.sendTo(new PacketMinecartButton(this.cart.m_19879_(), this.getPacketStart() + id, data), (ServerPlayer)player);
        }
    }

    protected void sendPacketAround(int id) {
        this.sendPacketAround(id, new byte[0]);
    }

    protected void sendPacketAround(int id, byte data) {
        this.sendPacketAround(id, new byte[]{data});
    }

    protected void sendPacketAround(int id, byte[] data) {
    }

    protected void receivePacket(int id, byte[] data, Player player) {
    }

    public final void delegateReceivedPacket(int id, byte[] data, Player player) {
        if (id < 0) {
            return;
        }
        if (id == this.totalNumberOfPackets() - 1 && this.useButtons()) {
            int buttonId = data[0];
            if (buttonId < 0) {
                buttonId += 256;
            }
            for (ButtonBase button : this.buttons) {
                if (button.getIdInModule() != buttonId) continue;
                byte buttoninformation = data[1];
                boolean isCtrlDown = (buttoninformation & 0x40) != 0;
                boolean isShiftDown = (buttoninformation & 0x80) != 0;
                int mousebutton = buttoninformation & 0x3F;
                if (button.isVisible() && button.isEnabled()) {
                    button.onServerClick(player, mousebutton, isCtrlDown, isShiftDown);
                }
                break;
            }
        } else {
            this.receivePacket(id, data, player);
        }
    }

    public int numberOfDataWatchers() {
        return 0;
    }

    public void initDw() {
    }

    protected final <T> void registerDw(EntityDataAccessor<T> key, T value) {
        for (SynchedEntityData.DataItem entry : this.getCart().getDataManager().m_135384_()) {
            if (entry.m_135396_() != key) continue;
            return;
        }
        this.getCart().getDataManager().m_135372_(key, value);
    }

    protected final <T> void updateDw(EntityDataAccessor<T> key, T value) {
        this.getCart().getDataManager().m_135381_(key, value);
    }

    protected <T> T getDw(EntityDataAccessor<T> key) {
        return (T)this.getCart().getDataManager().m_135370_(key);
    }

    protected <T> EntityDataAccessor<T> createDw(EntityDataSerializer<T> serializer) {
        return serializer.m_135021_(this.cart.getNextDataWatcher());
    }

    public int numberOfGuiData() {
        return 0;
    }

    public int getGuiDataStart() {
        return this.guiDataOffset;
    }

    public void setGuiDataStart(int val) {
        this.guiDataOffset = val;
    }

    private void updateGuiData(AbstractContainerMenu con, List<Player> players, int id, short data) {
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.sendTo(new PacketGuiData(con.f_38840_, id, data), serverPlayer);
        }
    }

    @Deprecated
    public final void updateGuiData(Object[] info, int id, short data) {
        this.updateGuiData((AbstractContainerMenu)info[0], (List)info[1], (Boolean)info[2], id, data);
    }

    public final void updateGuiData(AbstractContainerMenu containerMenu, List<Player> players, boolean isNew, int id, short data) {
        if (!(containerMenu instanceof ContainerMinecart)) {
            return;
        }
        ContainerMinecart con = (ContainerMinecart)containerMenu;
        int globalId = id + this.getGuiDataStart();
        if (!isNew) {
            Short val;
            isNew = con.cache != null ? (val = con.cache.get((short)globalId)) == null || val != data : true;
        }
        if (isNew) {
            if (con.cache == null) {
                con.cache = new HashMap();
            }
            this.updateGuiData(con, players, globalId, data);
            con.cache.put((short)globalId, data);
        }
    }

    public final void initGuiData(AbstractContainerMenu con, ContainerListener player) {
        ArrayList<Player> players = new ArrayList<Player>();
        players.add((Player)player);
        this.checkGuiData(con, players, true);
    }

    @Deprecated
    protected void checkGuiData(Object[] info) {
    }

    protected void doGuiDataCheck(AbstractContainerMenu con, List<Player> players, boolean isNew) {
        this.checkGuiData(new Object[]{con, players, isNew});
    }

    public final void checkGuiData(AbstractContainerMenu con, List<Player> players, boolean isNew) {
        if (con == null) {
            return;
        }
        this.doGuiDataCheck(con, players, isNew);
    }

    public void receiveGuiData(int id, short data) {
    }

    public int getConsumption(boolean isMoving) {
        return 0;
    }

    public void setModels(ArrayList<ModelCartbase> models) {
        this.models = models;
    }

    public ArrayList<ModelCartbase> getModels() {
        return this.models;
    }

    public boolean haveModels() {
        return this.models != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void drawStringOnMouseOver(PoseStack matrixStack, GuiMinecart gui, String str, int x, int y, int x1, int y1, int w, int h) {
        this.drawStringOnMouseOver(matrixStack, gui, str, x, y, new int[]{x1, y1, w, h});
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void drawStringOnMouseOver(PoseStack matrixStack, GuiMinecart gui, String str, int x, int y, int[] rect) {
        if (!this.inRect(x, y, rect)) {
            return;
        }
        gui.drawMouseOver(matrixStack, str, x += this.getX(), y += this.getY());
    }

    protected void drawImage(int[] rect, int sourceX, int sourceY) {
        this.drawImage(rect[0], rect[1], sourceX, sourceY, rect[2], rect[3]);
    }

    protected void drawImage(int targetX, int targetY, int sourceX, int sourceY, int width, int height) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_((double)targetX, (double)(targetY + height), -90.0).m_7421_((float)sourceX * 0.00390625f, (float)(sourceY + height) * 0.00390625f).m_5752_();
        bufferbuilder.m_5483_((double)(targetX + width), (double)(targetY + height), -90.0).m_7421_((float)(sourceX + width) * 0.00390625f, (float)(sourceY + height) * 0.00390625f).m_5752_();
        bufferbuilder.m_5483_((double)(targetX + width), (double)targetY, -90.0).m_7421_((float)(sourceX + width) * 0.00390625f, (float)sourceY * 0.00390625f).m_5752_();
        bufferbuilder.m_5483_((double)targetX, (double)targetY, -90.0).m_7421_((float)sourceX * 0.00390625f, (float)sourceY * 0.00390625f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Player getClientPlayer() {
        if (Minecraft.m_91087_() != null) {
            return Minecraft.m_91087_().f_91074_;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(PoseStack matrixStack, Minecraft minecraft) {
    }

    public boolean stopEngines() {
        return false;
    }

    public boolean shouldCartRender() {
        return true;
    }

    public double getPushFactor() {
        return -1.0;
    }

    public float[] getColor() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public float mountedOffset(Entity rider) {
        return 0.0f;
    }

    protected boolean countsAsAir(BlockPos pos) {
        if (this.getCart().f_19853_.m_8055_(pos).m_60795_()) {
            return true;
        }
        Block b = this.getCart().f_19853_.m_8055_(pos).m_60734_();
        return b instanceof SnowLayerBlock || b instanceof FlowerBlock || b instanceof VineBlock;
    }

    public void activatedByRail(int x, int y, int z, boolean active) {
    }

    public ModuleData getData() {
        return StevesCartsAPI.MODULE_REGISTRY.get(this.getModuleId());
    }

    public boolean doStealInterface() {
        return false;
    }

    public boolean hasExtraData() {
        return false;
    }

    public CompoundTag writeExtraData() {
        return new CompoundTag();
    }

    public void readExtraData(CompoundTag nbt) {
    }

    protected FakePlayer getFakePlayer() {
        return FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.getCart().f_19853_));
    }

    public boolean disableStandardKeyFunctionality() {
        return false;
    }

    public void addToLabel(ArrayList<Component> label) {
    }

    public boolean onInteractFirst(Player entityplayer) {
        return false;
    }

    public void postUpdate() {
    }

    public String getModuleName() {
        return I18n.m_118938_((String)("item.stevescarts." + StevesCartsAPI.MODULE_REGISTRY.get(this.getModuleId()).getRawName()), (Object[])new Object[0]);
    }

    public static enum RAILDIRECTION {
        DEFAULT,
        NORTH,
        WEST,
        SOUTH,
        EAST,
        LEFT,
        FORWARD,
        RIGHT;

    }
}

