/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.api.modules.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevescarts.api.IModuleItem;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.ModuleType;
import vswe.stevescarts.api.modules.data.ModuleDataGroup;
import vswe.stevescarts.api.modules.data.ModuleDataHull;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.init.ModItems;
import vswe.stevescarts.items.ItemCartModule;

public class ModuleData {
    private final ResourceLocation id;
    private final Class<? extends ModuleBase> moduleClass;
    private final String name;
    private final int modularCost;
    private ArrayList<SIDE> renderingSides;
    private boolean allowDuplicate;
    private ArrayList<ModuleData> nemesis = null;
    private ArrayList<ModuleDataGroup> requirement = null;
    private ModuleData parent = null;
    private boolean isLocked;
    private boolean defaultLock;
    private ArrayList<Localization.MODULE_INFO> message;
    @OnlyIn(value=Dist.CLIENT)
    private HashMap<String, ModelCartbase> models;
    @OnlyIn(value=Dist.CLIENT)
    private HashMap<String, ModelCartbase> modelsPlaceholder;
    private ArrayList<String> removedModels;
    private float modelMult = 0.75f;
    private boolean useExtraData;
    private byte extraDataDefaultValue;
    private static final int MAX_MESSAGE_ROW_LENGTH = 30;
    private final ModuleType moduleType;

    public ModuleData(ResourceLocation id, String name, Class<? extends ModuleBase> moduleClass, ModuleType moduleType, int modularCost) {
        this.id = id;
        this.moduleClass = moduleClass;
        this.name = name;
        this.modularCost = modularCost;
        this.moduleType = moduleType;
    }

    public Class<? extends ModuleBase> getModuleClass() {
        return this.moduleClass;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    @Deprecated(forRemoval=true)
    public boolean getIsValid() {
        return true;
    }

    @Deprecated(forRemoval=true)
    public boolean getIsLocked() {
        return this.isLocked;
    }

    protected ModuleData lock() {
        this.isLocked = true;
        return this;
    }

    public boolean getEnabledByDefault() {
        return !this.defaultLock;
    }

    protected ModuleData lockByDefault() {
        this.defaultLock = true;
        return this;
    }

    public ModuleData setAllowDuplicate() {
        this.allowDuplicate = true;
        return this;
    }

    protected boolean getAllowDuplicate() {
        return this.allowDuplicate;
    }

    public ModuleData addSide(SIDE side) {
        if (this.renderingSides == null) {
            this.renderingSides = new ArrayList();
        }
        this.renderingSides.add(side);
        if (side == SIDE.TOP) {
            this.removeModel("Rails");
        }
        return this;
    }

    public ModuleData useExtraData(byte defaultValue) {
        this.extraDataDefaultValue = defaultValue;
        this.useExtraData = true;
        return this;
    }

    public boolean isUsingExtraData() {
        return this.useExtraData;
    }

    public byte getDefaultExtraData() {
        return this.extraDataDefaultValue;
    }

    public ArrayList<SIDE> getRenderingSides() {
        return this.renderingSides;
    }

    public ModuleData addSides(SIDE[] sides) {
        for (SIDE side : sides) {
            this.addSide(side);
        }
        return this;
    }

    public ModuleData addParent(ModuleData parent) {
        this.parent = parent;
        return this;
    }

    public ModuleData addMessage(Localization.MODULE_INFO s) {
        if (this.message == null) {
            this.message = new ArrayList();
        }
        this.message.add(s);
        return this;
    }

    protected void addNemesis(ModuleData nemesis) {
        if (this.nemesis == null) {
            this.nemesis = new ArrayList();
        }
        this.nemesis.add(nemesis);
    }

    public ModuleData addRequirement(ModuleDataGroup requirement) {
        if (this.requirement == null) {
            this.requirement = new ArrayList();
        }
        this.requirement.add(requirement);
        return this;
    }

    protected static void addNemesis(ModuleData m1, ModuleData m2) {
        m2.addNemesis(m1);
        m1.addNemesis(m2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getModelMult() {
        return this.modelMult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModuleData setModelMult(float val) {
        this.modelMult = val;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModuleData addModel(String tag, ModelCartbase model) {
        this.addModel(tag, model, false);
        this.addModel(tag, model, true);
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModuleData addModel(String tag, ModelCartbase model, boolean placeholder) {
        if (placeholder) {
            if (this.modelsPlaceholder == null) {
                this.modelsPlaceholder = new HashMap();
            }
            this.modelsPlaceholder.put(tag, model);
        } else {
            if (this.models == null) {
                this.models = new HashMap();
            }
            this.models.put(tag, model);
        }
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HashMap<String, ModelCartbase> getModels(boolean placeholder) {
        if (placeholder) {
            return this.modelsPlaceholder;
        }
        return this.models;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean haveModels(boolean placeholder) {
        if (placeholder) {
            return this.modelsPlaceholder != null;
        }
        return this.models != null;
    }

    public ModuleData removeModel(String tag) {
        if (this.removedModels == null) {
            this.removedModels = new ArrayList();
        }
        if (!this.removedModels.contains(tag)) {
            this.removedModels.add(tag);
        }
        return this;
    }

    public ArrayList<String> getRemovedModels() {
        return this.removedModels;
    }

    public boolean haveRemovedModels() {
        return this.removedModels != null;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getName() {
        return "module_" + this.getRawName();
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public int getCost() {
        return this.modularCost;
    }

    protected ModuleData getParent() {
        return this.parent;
    }

    protected ArrayList<ModuleData> getNemesis() {
        return this.nemesis;
    }

    protected ArrayList<ModuleDataGroup> getRequirement() {
        return this.requirement;
    }

    public String getModuleInfoText(byte b) {
        return null;
    }

    public String getCartInfoText(String name, CompoundTag extraData) {
        return name;
    }

    public static NonNullList<ItemStack> getModularItems(@Nonnull ItemStack cart) {
        CompoundTag info;
        NonNullList modules = NonNullList.m_122779_();
        if (!cart.m_41619_() && cart.m_41720_() == ModItems.CARTS.get() && cart.m_41783_() != null && (info = cart.m_41783_()).m_128441_("modules")) {
            int i = 0;
            for (Tag tag : info.m_128437_("modules", 10)) {
                CompoundTag moduleTag = (CompoundTag)tag;
                String regName = moduleTag.m_128461_(String.valueOf(i));
                ModuleData data = StevesCartsAPI.MODULE_REGISTRY.get(new ResourceLocation(regName));
                ItemCartModule item = (ItemCartModule)ModItems.MODULES.get(data).get();
                ItemStack module = new ItemStack((ItemLike)item);
                if (moduleTag.m_128441_("data")) {
                    module.m_41700_("data", (Tag)moduleTag.m_128469_("data"));
                }
                modules.add((Object)module);
                ++i;
            }
        }
        return modules;
    }

    public static ItemStack createModularCart(EntityMinecartModular parentcart) {
        ItemStack cart = new ItemStack((ItemLike)ModItems.CARTS.get(), 1);
        ListTag modulesTag = new ListTag();
        for (int i = 0; i < parentcart.getModules().size(); ++i) {
            CompoundTag moduleTag = new CompoundTag();
            ModuleBase module = parentcart.getModules().get(i);
            moduleTag.m_128359_(String.valueOf(i), module.getModuleId().toString());
            if (module.hasExtraData()) {
                moduleTag.m_128365_("data", (Tag)module.writeExtraData());
            }
            modulesTag.add(i, (Tag)moduleTag);
        }
        cart.m_41784_().m_128365_("modules", (Tag)modulesTag);
        return cart;
    }

    public static ItemStack createModularCartFromItems(NonNullList<ItemStack> modules) {
        ItemStack cart = new ItemStack((ItemLike)ModItems.CARTS.get(), 1);
        ListTag modulesTag = new ListTag();
        for (int i = 0; i < modules.size(); ++i) {
            CompoundTag moduleTag = new CompoundTag();
            ItemStack moduleStack = (ItemStack)modules.get(i);
            IModuleItem cartModule = (IModuleItem)moduleStack.m_41720_();
            moduleTag.m_128359_(String.valueOf(i), cartModule.getModuleData().getID().toString());
            if (moduleStack.m_41782_() && moduleStack.m_41784_().m_128441_("data")) {
                moduleTag.m_128365_("data", (Tag)moduleStack.m_41784_().m_128469_("data"));
            }
            modulesTag.add(i, (Tag)moduleTag);
        }
        cart.m_41784_().m_128365_("modules", (Tag)modulesTag);
        return cart;
    }

    public static boolean isItemOfModularType(@Nonnull ItemStack itemstack, Class<? extends ModuleBase> validClass) {
        Item item = itemstack.m_41720_();
        if (item instanceof ItemCartModule) {
            ItemCartModule itemCartModule = (ItemCartModule)item;
            ModuleData moduleData = itemCartModule.getModuleData();
            return moduleData != null && validClass.isAssignableFrom(moduleData.moduleClass);
        }
        return false;
    }

    @Nonnull
    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_41852_);
        if (ModItems.MODULES.get(this) != null) {
            stack = new ItemStack((ItemLike)ModItems.MODULES.get(this).get());
        }
        return stack;
    }

    public static boolean isValidModuleItem(ModuleType moduleType, @Nonnull ItemStack itemstack) {
        Item item = itemstack.m_41720_();
        if (item instanceof IModuleItem) {
            IModuleItem itemCartModule = (IModuleItem)item;
            ModuleData module = itemCartModule.getModuleData();
            return ModuleData.isValidModuleItem(moduleType, module);
        }
        return false;
    }

    public static boolean isValidModuleItem(ModuleType moduleType, ModuleData module) {
        if (module != null) {
            return module.getModuleType() == moduleType;
        }
        return false;
    }

    public static boolean isValidModuleCombo(ModuleDataHull hull, ArrayList<ModuleData> modules) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addExtraMessage(List<Component> list) {
        if (this.message != null) {
            list.add((Component)Component.m_237113_((String)""));
            for (Localization.MODULE_INFO m : this.message) {
                String str = m.translate(new String[0]);
                if (str.length() <= 30) {
                    this.addExtraMessage(list, str);
                    continue;
                }
                String[] words = str.split(" ");
                String row = "";
                for (String word : words) {
                    String next = (row + " " + word).trim();
                    if (next.length() <= 30) {
                        row = next;
                        continue;
                    }
                    this.addExtraMessage(list, row);
                    row = word;
                }
                this.addExtraMessage(list, row);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addExtraMessage(List<Component> list, String str) {
        list.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_GRAY + ChatFormatting.ITALIC + str + ChatFormatting.RESET)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void addInformation(List<Component> list, CompoundTag compound) {
        String extradatainfo;
        list.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + Localization.MODULE_INFO.MODULAR_COST.translate(new String[0]) + ": " + this.modularCost)));
        if (compound != null && compound.m_128441_("Data") && (extradatainfo = this.getModuleInfoText(compound.m_128445_("Data"))) != null) {
            list.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + extradatainfo)));
        }
        if (Screen.m_96638_()) {
            if (this.getRenderingSides() == null || this.getRenderingSides().size() == 0) {
                list.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_AQUA + Localization.MODULE_INFO.NO_SIDES.translate(new String[0]))));
            } else {
                StringBuilder sides = new StringBuilder();
                for (int i = 0; i < this.getRenderingSides().size(); ++i) {
                    SIDE side = this.getRenderingSides().get(i);
                    if (i == 0) {
                        sides.append(side.toString());
                        continue;
                    }
                    if (i == this.getRenderingSides().size() - 1) {
                        sides.append(" ").append(Localization.MODULE_INFO.AND.translate(new String[0])).append(" ").append(side.toString());
                        continue;
                    }
                    sides.append(", ").append(side.toString());
                }
                list.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_AQUA + Localization.MODULE_INFO.OCCUPIED_SIDES.translate(sides.toString(), String.valueOf(this.getRenderingSides().size())))));
            }
            if (this.getNemesis() != null && this.getNemesis().size() != 0) {
                if (this.getRenderingSides() == null || this.getRenderingSides().size() == 0) {
                    list.add((Component)Component.m_237113_((String)(ChatFormatting.RED + Localization.MODULE_INFO.CONFLICT_HOWEVER.translate(new String[0]) + ":")));
                } else {
                    list.add((Component)Component.m_237113_((String)(ChatFormatting.RED + Localization.MODULE_INFO.CONFLICT_ALSO.translate(new String[0]) + ":")));
                }
                for (ModuleData module : this.getNemesis()) {
                    list.add((Component)Component.m_237113_((String)(ChatFormatting.RED + module.getName())));
                }
            }
            if (this.parent != null) {
                list.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + Localization.MODULE_INFO.REQUIREMENT.translate(new String[0]) + " " + this.parent.getName())));
            }
            if (this.getRequirement() != null && this.getRequirement().size() != 0) {
                for (ModuleDataGroup group : this.getRequirement()) {
                    list.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + Localization.MODULE_INFO.REQUIREMENT.translate(new String[0]) + " " + group.getCountName() + " " + group.getName())));
                }
            }
            if (this.getAllowDuplicate()) {
                list.add((Component)Component.m_237113_((String)(ChatFormatting.GREEN + Localization.MODULE_INFO.DUPLICATES.translate(new String[0]))));
            }
        } else {
            list.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_AQUA + Localization.MODULE_INFO.SHIFT_FOR_MORE.translate("SHIFT"))));
        }
        list.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + "Module Type: " + ChatFormatting.WHITE + this.moduleType.name())));
        this.addExtraMessage(list);
    }

    public static String checkForErrors(ModuleDataHull hull, ArrayList<ModuleData> modules) {
        if (ModuleData.getTotalCost(modules) > hull.getCapacity()) {
            return Localization.MODULE_INFO.CAPACITY_ERROR.translate(new String[0]);
        }
        if (!ModuleData.isValidModuleCombo(hull, modules)) {
            return Localization.MODULE_INFO.COMBINATION_ERROR.translate(new String[0]);
        }
        for (int i = 0; i < modules.size(); ++i) {
            ModuleData mod1 = modules.get(i);
            if (mod1.getCost() > hull.getComplexityMax()) {
                return Localization.MODULE_INFO.COMPLEXITY_ERROR.translate(mod1.getName());
            }
            if (mod1.getParent() != null && !modules.contains(mod1.getParent())) {
                return Localization.MODULE_INFO.PARENT_ERROR.translate(mod1.getName(), mod1.getParent().getName());
            }
            if (mod1.getNemesis() != null) {
                for (ModuleData nemesis : mod1.getNemesis()) {
                    if (!modules.contains(nemesis)) continue;
                    return Localization.MODULE_INFO.NEMESIS_ERROR.translate(mod1.getName(), nemesis.getName());
                }
            }
            if (mod1.getRequirement() != null) {
                for (ModuleDataGroup group : mod1.getRequirement()) {
                    int count = 0;
                    for (ModuleData mod2 : group.getModules()) {
                        for (ModuleData mod3 : modules) {
                            if (!mod2.equals(mod3)) continue;
                            ++count;
                        }
                    }
                    if (count >= group.getCount()) continue;
                    return Localization.MODULE_INFO.PARENT_ERROR.translate(mod1.getName(), group.getCountName() + " " + group.getName());
                }
            }
            for (int j = i + 1; j < modules.size(); ++j) {
                ModuleData mod4 = modules.get(j);
                if (mod1 == mod4) {
                    if (mod1.getAllowDuplicate()) continue;
                    return Localization.MODULE_INFO.DUPLICATE_ERROR.translate(mod1.getName());
                }
                if (mod1.getRenderingSides() == null || mod4.getRenderingSides() == null) continue;
                SIDE clash = SIDE.NONE;
                for (SIDE side1 : mod1.getRenderingSides()) {
                    for (SIDE side2 : mod4.getRenderingSides()) {
                        if (side1 != side2) continue;
                        clash = side1;
                        break;
                    }
                    if (clash == SIDE.NONE) continue;
                    break;
                }
                if (clash == SIDE.NONE) continue;
                return Localization.MODULE_INFO.CLASH_ERROR.translate(mod1.getName(), mod4.getName(), clash.toString());
            }
        }
        return null;
    }

    public static int getTotalCost(ArrayList<ModuleData> modules) {
        int currentCost = 0;
        for (ModuleData module : modules) {
            currentCost += module.getCost();
        }
        return currentCost;
    }

    private static long calculateCombinations() {
        long combinations = 0L;
        ArrayList<ModuleData> potential = new ArrayList<ModuleData>();
        for (ModuleData module : StevesCartsAPI.MODULE_REGISTRY.values()) {
            if (module instanceof ModuleDataHull) continue;
            potential.add(module);
        }
        for (ModuleData module : StevesCartsAPI.MODULE_REGISTRY.values()) {
            if (!(module instanceof ModuleDataHull)) continue;
            ArrayList<ModuleData> modules = new ArrayList<ModuleData>();
            System.out.println("Hull added: " + (combinations += ModuleData.populateHull((ModuleDataHull)module, modules, (ArrayList)potential.clone(), 0)));
        }
        return combinations;
    }

    private static long populateHull(ModuleDataHull hull, ArrayList<ModuleData> attached, ArrayList<ModuleData> potential, int depth) {
        if (ModuleData.checkForErrors(hull, attached) != null) {
            return 0L;
        }
        long combinations = 1L;
        Iterator<ModuleData> itt = potential.iterator();
        while (itt.hasNext()) {
            ModuleData module = itt.next();
            ArrayList attachedCopy = (ArrayList)attached.clone();
            attachedCopy.add(module);
            ArrayList potentialCopy = (ArrayList)potential.clone();
            itt.remove();
            combinations += ModuleData.populateHull(hull, attachedCopy, potentialCopy, depth + 1);
            if (depth >= 3) continue;
            System.out.println("Modular state[" + depth + "]: " + combinations);
        }
        return combinations;
    }

    public String getRawName() {
        return this.name.replace(":", "").replace("'", "").replace(" ", "_").replace("-", "_").toLowerCase();
    }

    public static enum SIDE {
        NONE(Localization.MODULE_INFO.SIDE_NONE),
        TOP(Localization.MODULE_INFO.SIDE_TOP),
        CENTER(Localization.MODULE_INFO.SIDE_CENTER),
        BOTTOM(Localization.MODULE_INFO.SIDE_BOTTOM),
        BACK(Localization.MODULE_INFO.SIDE_BACK),
        LEFT(Localization.MODULE_INFO.SIDE_LEFT),
        RIGHT(Localization.MODULE_INFO.SIDE_RIGHT),
        FRONT(Localization.MODULE_INFO.SIDE_FRONT);

        private final Localization.MODULE_INFO name;

        private SIDE(Localization.MODULE_INFO name) {
            this.name = name;
        }

        public String toString() {
            return this.name.translate(new String[0]);
        }
    }
}

