/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.upgrades.AssemblerUpgrade;
import vswe.stevescarts.upgrades.BaseEffect;

public class BlockUpgrade
extends BlockContainerBase {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");
    private static final VoxelShape[] BBS = new VoxelShape[6];
    private final AssemblerUpgrade assemblerUpgrade;

    public BlockUpgrade(AssemblerUpgrade assemblerUpgrade) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60955_().m_60977_().m_60978_(2.0f));
        this.assemblerUpgrade = assemblerUpgrade;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CONNECTED});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter blockReader, @NotNull BlockPos blockPos, @NotNull CollisionContext selectionContext) {
        return BBS[((Direction)state.m_61143_((Property)FACING)).m_122424_().ordinal()];
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext blockItemUseContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockItemUseContext.m_8125_())).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityUpgrade(this.assemblerUpgrade, blockPos, blockState);
    }

    public boolean m_7898_(@NotNull BlockState blockState, LevelReader iWorldReader, BlockPos blockPos) {
        BlockPos offset = blockPos.m_121945_(this.getFacing(blockState));
        return iWorldReader.m_7702_(offset) != null && iWorldReader.m_7702_(offset) instanceof TileEntityCartAssembler;
    }

    public Direction getFacing(BlockState blockState) {
        return (Direction)blockState.m_61143_((Property)FACING);
    }

    public void m_213898_(@NotNull BlockState blockState, @NotNull ServerLevel serverWorld, @NotNull BlockPos blockPos, @NotNull RandomSource p_225542_4_) {
        if (!this.m_7898_(blockState, (LevelReader)serverWorld, blockPos) && serverWorld.m_7471_(blockPos, true)) {
            ItemEntity item = new ItemEntity((Level)serverWorld, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), new ItemStack((ItemLike)this));
            serverWorld.m_7967_((Entity)item);
        }
        super.m_213898_(blockState, serverWorld, blockPos, p_225542_4_);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, Level world, @NotNull BlockPos blockPos, @NotNull Player playerEntity, @NotNull InteractionHand hand, @NotNull BlockHitResult rayTraceResult) {
        if (!world.f_46443_ && !playerEntity.m_6047_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)((MenuProvider)world.m_7702_(blockPos)), (BlockPos)blockPos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(@NotNull ItemStack itemStack, @javax.annotation.Nullable BlockGetter iBlockReader, @NotNull List<Component> tooltip, @NotNull TooltipFlag iTooltipFlag) {
        if (this.assemblerUpgrade != null) {
            for (BaseEffect effect : this.assemblerUpgrade.getEffects()) {
                tooltip.add((Component)Component.m_237113_((String)effect.getName()));
            }
        }
    }

    static {
        float thickness = 2.0f;
        BlockUpgrade.BBS[Direction.UP.ordinal()] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)thickness, (double)16.0);
        BlockUpgrade.BBS[Direction.DOWN.ordinal()] = Block.m_49796_((double)0.0, (double)(16.0f - thickness), (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        BlockUpgrade.BBS[Direction.EAST.ordinal()] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)16.0, (double)16.0);
        BlockUpgrade.BBS[Direction.WEST.ordinal()] = Block.m_49796_((double)(16.0f - thickness), (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        BlockUpgrade.BBS[Direction.NORTH.ordinal()] = Block.m_49796_((double)0.0, (double)0.0, (double)(16.0f - thickness), (double)16.0, (double)16.0, (double)16.0);
        BlockUpgrade.BBS[Direction.SOUTH.ordinal()] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)thickness);
    }
}

