/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.containers.ContainerActivator;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.ActivatorOption;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.modules.addons.ModuleChunkLoader;
import vswe.stevescarts.modules.addons.ModuleInvisible;
import vswe.stevescarts.modules.addons.ModuleShield;
import vswe.stevescarts.modules.realtimers.ModuleCage;
import vswe.stevescarts.modules.workers.ModuleRemover;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class TileEntityActivator
extends TileEntityBase
implements MenuProvider {
    private ArrayList<ActivatorOption> options;

    public TileEntityActivator(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.MODULE_TOGGLER_TILE.get(), blockPos, blockState);
        this.loadOptions();
    }

    private void loadOptions() {
        this.options = new ArrayList<ActivatorOption>();
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_DRILL, ModuleDrill.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_SHIELD, ModuleShield.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_INVISIBILITY, ModuleInvisible.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CHUNK, ModuleChunkLoader.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CAGE_AUTO, ModuleCage.class, 0));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CAGE, ModuleCage.class, 1));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_REMOVER, ModuleRemover.class));
    }

    public ArrayList<ActivatorOption> getOptions() {
        return this.options;
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        for (ActivatorOption option : this.options) {
            option.setOption(compoundTag.m_128445_(option.getName()));
        }
    }

    public void m_183515_(@NotNull CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        for (ActivatorOption option : this.options) {
            compoundNBT.m_128344_(option.getName(), (byte)option.getOption());
        }
    }

    public void receivePacket(int id, byte[] data, @Nullable ServerPlayer sender) {
        if (id == 0) {
            boolean leftClick = (data[0] & 1) == 0;
            int optionId = (data[0] & 0xFFFFFFFE) >> 1;
            if (optionId >= 0 && optionId < this.options.size()) {
                this.options.get(optionId).changeOption(leftClick);
            }
        }
    }

    public void handleCart(EntityMinecartModular cart, boolean isOrange) {
        for (ActivatorOption option : this.options) {
            if (option.isDisabled()) continue;
            cart.handleActivator(option, isOrange);
        }
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.activator");
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new ContainerActivator(id, playerInventory, this, new SimpleContainerData(0));
    }
}

